/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.block.group.join;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.block.group.join.BlockUserJoinGroupResponse;
import com.easemob.im.server.api.block.group.join.GetBlockedUsersResponse;
import com.easemob.im.server.api.block.group.join.UnblockUserJoinGroupResponse;
import com.easemob.im.server.exception.EMUnknownException;
import com.easemob.im.server.model.EMBlock;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class BlockUserJoinGroup {
    private Context context;

    public BlockUserJoinGroup(Context context) {
        this.context = context;
    }

    public Flux<EMBlock> getBlockedUsers(String groupId) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/chatgroups/%s/blocks/users", groupId))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, GetBlockedUsersResponse.class)).flatMapIterable(GetBlockedUsersResponse::getUsernames).map(username -> new EMBlock((String)username, null));
    }

    public Mono<Void> blockUser(String username, String groupId) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().post().uri(String.format("/chatgroups/%s/blocks/users/%s", groupId, username))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, BlockUserJoinGroupResponse.class)).handle((rsp, sink) -> {
            if (!rsp.getSuccess()) {
                sink.error((Throwable)new EMUnknownException("unknown"));
                return;
            }
            sink.complete();
        });
    }

    public Mono<Void> unblockUser(String username, String groupId) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().delete().uri(String.format("/chatgroups/%s/blocks/users/%s", groupId, username))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, UnblockUserJoinGroupResponse.class)).handle((rsp, sink) -> {
            if (!rsp.getSuccess()) {
                sink.error((Throwable)new EMUnknownException("unknown"));
                return;
            }
            sink.complete();
        });
    }
}

