/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.block.group.msg;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.block.group.msg.BlockUserSendMsgToGroupRequest;
import com.easemob.im.server.api.block.group.msg.BlockUserSendMsgToGroupResponse;
import com.easemob.im.server.api.block.group.msg.GetUsersBlockedSendMsgToGroupResponse;
import com.easemob.im.server.api.block.group.msg.UnblockUserSendMsgToGroupResponse;
import com.easemob.im.server.exception.EMUnknownException;
import com.easemob.im.server.model.EMBlock;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class BlockUserSendMsgToGroup {
    private Context context;

    public BlockUserSendMsgToGroup(Context context) {
        this.context = context;
    }

    public Flux<EMBlock> getBlockedUsers(String groupId) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/chatgroups/%s/mute", groupId))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(rsp -> this.context.getCodec().decode((ByteBuf)rsp, GetUsersBlockedSendMsgToGroupResponse.class)).flatMapIterable(GetUsersBlockedSendMsgToGroupResponse::getEMBlocks);
    }

    public Mono<Void> blockUser(String username, String groupId, Duration duration) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().post().uri(String.format("/chatgroups/%s/mute", groupId))).send((Publisher)Mono.create(sink -> sink.success((Object)this.context.getCodec().encode(BlockUserSendMsgToGroupRequest.of(username, duration))))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, BlockUserSendMsgToGroupResponse.class)).handle((rsp, sink) -> {
            if (!rsp.getSuccess(username)) {
                sink.error((Throwable)new EMUnknownException("unknown"));
                return;
            }
            sink.complete();
        });
    }

    public Mono<Void> unblockUser(String username, String groupId) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().delete().uri(String.format("/chatgroups/%s/mute/%s", groupId, username))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, UnblockUserSendMsgToGroupResponse.class)).handle((rsp, sink) -> {
            if (!rsp.getSuccess(username)) {
                sink.error((Throwable)new EMUnknownException("unknown"));
                return;
            }
            sink.complete();
        });
    }
}

