/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.block.room.join;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.block.room.join.BlockUserJoinRoomResponse;
import com.easemob.im.server.api.block.room.join.GetBlockedUsersResponse;
import com.easemob.im.server.api.block.room.join.UnblockUserJoinRoomResponse;
import com.easemob.im.server.exception.EMUnknownException;
import com.easemob.im.server.model.EMBlock;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class BlockUserJoinRoom {
    private Context context;

    public BlockUserJoinRoom(Context context) {
        this.context = context;
    }

    public Flux<EMBlock> getBlockedUsers(String roomId) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/chatrooms/%s/blocks/users", roomId))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, GetBlockedUsersResponse.class)).flatMapIterable(GetBlockedUsersResponse::getUsernames).map(username -> new EMBlock((String)username, null));
    }

    public Mono<Void> blockUser(String username, String roomId) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().post().uri(String.format("/chatrooms/%s/blocks/users/%s", roomId, username))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, BlockUserJoinRoomResponse.class)).handle((rsp, sink) -> {
            if (!rsp.isSuccess()) {
                sink.error((Throwable)new EMUnknownException("unknown"));
                return;
            }
            sink.complete();
        });
    }

    public Mono<Void> unblockUser(String username, String roomId) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().delete().uri(String.format("/chatrooms/%s/blocks/users/%s", roomId, username))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, UnblockUserJoinRoomResponse.class)).handle((rsp, sink) -> {
            if (!rsp.isSuccess()) {
                sink.error((Throwable)new EMUnknownException("unknown"));
                return;
            }
            sink.complete();
        });
    }
}

