/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.block.user;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.block.user.BlockUsersSendMsgToUserRequest;
import com.easemob.im.server.api.block.user.GetUsersBlockedSendMsgToUserResponse;
import com.easemob.im.server.exception.EMInvalidArgumentException;
import com.easemob.im.server.model.EMBlock;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class SendMsgToUser {
    private Context context;

    public SendMsgToUser(Context context) {
        this.context = context;
    }

    public Flux<EMBlock> getUsersBlocked(String username) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/users/%s/blocks/users", username))).responseSingle((httpRsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)httpRsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, GetUsersBlockedSendMsgToUserResponse.class)).flatMapIterable(GetUsersBlockedSendMsgToUserResponse::getUsernames).map(blockedUsername -> new EMBlock((String)blockedUsername, null));
    }

    public Mono<Void> blockUser(String fromUser, String toUser) {
        if (fromUser.equals(toUser)) {
            return Mono.error((Throwable)new EMInvalidArgumentException("user could not block himself"));
        }
        return ((HttpClient.RequestSender)this.context.getHttpClient().post().uri(String.format("/users/%s/blocks/users", toUser))).send((Publisher)Mono.create(sink -> sink.success((Object)this.context.getCodec().encode(new BlockUsersSendMsgToUserRequest(Arrays.asList(fromUser)))))).response().flatMap(rsp -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then());
    }

    public Mono<Void> unblockUser(String fromUser, String toUser) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().delete().uri(String.format("/users/%s/blocks/users/%s", toUser, fromUser))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then());
    }
}

