/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.contact.user;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.contact.user.ContactUserListResponse;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class ContactUser {
    private Context context;

    public ContactUser(Context context) {
        this.context = context;
    }

    public Mono<Void> add(String user, String contact) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().post().uri(String.format("/users/%s/contacts/users/%s", user, contact))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then());
    }

    public Mono<Void> remove(String user, String contact) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().delete().uri(String.format("/users/%s/contacts/users/%s", user, contact))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then());
    }

    public Flux<String> list(String user) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/users/%s/contacts/users", user))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, ContactUserListResponse.class)).flatMapIterable(ContactUserListResponse::getUsernames);
    }
}

