/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.group.announcement;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.group.announcement.GroupAnnouncementGetResponse;
import com.easemob.im.server.api.group.announcement.GroupAnnouncementResource;
import com.easemob.im.server.exception.EMInvalidArgumentException;
import io.netty.buffer.ByteBuf;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class GroupAnnouncement {
    private Context context;

    public GroupAnnouncement(Context context) {
        this.context = context;
    }

    public Mono<String> get(String groupId) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/chatgroups/%s/announcement", groupId))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, GroupAnnouncementGetResponse.class)).map(GroupAnnouncementGetResponse::getAnnouncement);
    }

    public Mono<Void> set(String groupId, String announcement) {
        if (announcement.length() > 512) {
            return Mono.error((Throwable)new EMInvalidArgumentException("announcement must not be longer than 512 characters"));
        }
        return ((HttpClient.RequestSender)this.context.getHttpClient().post().uri(String.format("/chatgroups/%s/announcement", groupId))).send((Publisher)Mono.create(sink -> sink.success((Object)this.context.getCodec().encode(new GroupAnnouncementResource(announcement))))).response().flatMap(rsp -> this.context.getErrorMapper().apply((HttpClientResponse)rsp)).then();
    }
}

