/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.group.create;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.group.create.CreateGroupRequest;
import com.easemob.im.server.api.group.create.CreateGroupResponse;
import com.easemob.im.server.exception.EMUnknownException;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class CreateGroup {
    private Context context;

    public CreateGroup(Context context) {
        this.context = context;
    }

    public Mono<String> publicGroup(String owner, String groupName, String description, List<String> members, int maxMembers, boolean needApproveToJoin) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().post().uri("/chatgroups")).send((Publisher)Mono.create(sink -> sink.success((Object)this.context.getCodec().encode(new CreateGroupRequest(groupName, description, true, owner, members, maxMembers, false, needApproveToJoin))))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, CreateGroupResponse.class)).handle((rsp, sink) -> {
            String groupId = rsp.getGroupId();
            if (groupId == null) {
                sink.error((Throwable)new EMUnknownException("groupId is null"));
            }
            sink.next((Object)groupId);
        });
    }

    public Mono<String> privateGroup(String owner, String groupName, String description, List<String> members, int maxMembers, boolean canMemberInvite) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().post().uri("/chatgroups")).send((Publisher)Mono.create(sink -> sink.success((Object)this.context.getCodec().encode(new CreateGroupRequest(groupName, description, false, owner, members, maxMembers, canMemberInvite, !canMemberInvite))))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, CreateGroupResponse.class)).handle((rsp, sink) -> {
            String groupId = rsp.getGroupId();
            if (groupId == null) {
                sink.error((Throwable)new EMUnknownException("groupId is null"));
            }
            sink.next((Object)groupId);
        });
    }
}

