/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.group.get;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.group.get.GetGroupResponse;
import com.easemob.im.server.exception.EMNotFoundException;
import com.easemob.im.server.model.EMGroup;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class GetGroup {
    private Context context;

    public GetGroup(Context context) {
        this.context = context;
    }

    public Mono<EMGroup> execute(String groupId) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/chatgroups/%s", groupId))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, GetGroupResponse.class)).map(rsp -> {
            EMGroup detail = rsp.toGroupDetail(groupId);
            if (detail == null) {
                throw new EMNotFoundException(String.format("group:%s", groupId));
            }
            return detail;
        });
    }
}

