/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.group.get;

import com.easemob.im.server.model.EMGroup;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;

public class GetGroupResponse {
    @JsonProperty(value="data")
    private List<GroupDetailResource> groupDetails;

    @JsonCreator
    public GetGroupResponse(@JsonProperty(value="data") List<GroupDetailResource> groupDetails) {
        this.groupDetails = groupDetails;
    }

    public EMGroup toGroupDetail(String groupId) {
        return this.groupDetails.stream().filter(groupDetailResource -> ((GroupDetailResource)groupDetailResource).groupId.equals(groupId)).map(GroupDetailResource::toEMGroup).findFirst().orElse(null);
    }

    public List<EMGroup> toGroupDetails() {
        return this.groupDetails.stream().map(GroupDetailResource::toEMGroup).collect(Collectors.toList());
    }

    private static class GroupDetailResource {
        @JsonProperty(value="id")
        private String groupId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="membersonly")
        private boolean needApproveToJoin;
        @JsonProperty(value="allowinvites")
        private boolean memberCanInviteOthers;
        @JsonProperty(value="owner")
        private String owner;
        @JsonProperty(value="maxusers")
        private int maxMembers;
        @JsonProperty(value="public")
        private boolean isPublic;

        private GroupDetailResource() {
        }

        public EMGroup toEMGroup() {
            return new EMGroup(this.groupId, this.name, this.description, this.isPublic, this.needApproveToJoin, this.memberCanInviteOthers, this.owner, this.maxMembers);
        }
    }
}

