/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.group.list;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.group.list.GroupListResponse;
import com.easemob.im.server.model.EMPage;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class GroupList {
    private Context context;

    public GroupList(Context context) {
        this.context = context;
    }

    public Flux<String> all(int limit) {
        return this.next(limit, null).expand(rsp -> rsp.getCursor() == null ? Mono.empty() : this.next(limit, rsp.getCursor())).concatMapIterable(EMPage::getValues);
    }

    public Mono<EMPage<String>> next(int limit, String cursor) {
        String path = String.format("/chatgroups?limit=%s", limit);
        if (cursor != null) {
            path = String.format("%s&cursor=%s", path, cursor);
        }
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(path)).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, GroupListResponse.class)).map(GroupListResponse::toEMPage);
    }

    public Flux<String> userJoined(String username) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/users/%s/joined_chatgroups", username))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, GroupListResponse.class)).flatMapIterable(GroupListResponse::getGroupIds);
    }
}

