/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.group.list;

import com.easemob.im.server.model.EMPage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GroupListResponse {
    @JsonProperty(value="data")
    private List<GroupResource> groups;
    @JsonProperty(value="cursor")
    private String cursor;

    @JsonCreator
    public GroupListResponse(@JsonProperty(value="data") List<GroupResource> groups, @JsonProperty(value="cursor") String cursor) {
        this.groups = groups;
        this.cursor = cursor;
    }

    public List<String> getGroupIds() {
        return this.groups.stream().map(GroupResource::getGroupId).collect(Collectors.toList());
    }

    public EMPage<String> toEMPage() {
        List groupIds = this.groups.stream().map(GroupResource::getGroupId).collect(Collectors.toList());
        return new EMPage<String>(groupIds, this.cursor);
    }

    public String getCursor() {
        return this.cursor;
    }

    public String toString() {
        return "GroupListResponse{groups=" + this.groups + ", cursor='" + this.cursor + '\'' + '}';
    }

    private static class GroupResource {
        @JsonProperty(value="groupid")
        private String groupId;

        @JsonCreator
        public GroupResource(@JsonProperty(value="groupid") String groupId) {
            this.groupId = groupId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String toString() {
            return "GroupResource{groupId='" + this.groupId + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GroupResource)) {
                return false;
            }
            GroupResource that = (GroupResource)o;
            return Objects.equals(this.groupId, that.groupId);
        }

        public int hashCode() {
            return Objects.hash(this.groupId);
        }
    }
}

