/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.group.settings;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.group.settings.UpdateGroupOwnerRequest;
import com.easemob.im.server.api.group.settings.UpdateGroupRequest;
import com.easemob.im.server.api.group.settings.UpdateGroupResponse;
import com.easemob.im.server.exception.EMUnknownException;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class UpdateGroup {
    private Context context;

    public UpdateGroup(Context context) {
        this.context = context;
    }

    public Mono<Void> update(String groupId, Consumer<UpdateGroupRequest> customizer) {
        UpdateGroupRequest request = new UpdateGroupRequest();
        customizer.accept(request);
        return ((HttpClient.RequestSender)this.context.getHttpClient().put().uri(String.format("/chatgroups/%s", groupId))).send((Publisher)Mono.create(sink -> sink.success((Object)this.context.getCodec().encode(request)))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, UpdateGroupResponse.class)).doOnNext(rsp -> {
            if (!(request.getMaxMembers() == null || rsp.getMaxMembersUpdated() != null && rsp.getMaxMembersUpdated().booleanValue())) {
                throw new EMUnknownException("maxMembers");
            }
            if (!(request.getCanMemberInviteOthers() == null || rsp.getMemberCanInviteOthersUpdated() != null && rsp.getMemberCanInviteOthersUpdated().booleanValue())) {
                throw new EMUnknownException("memberCanInviteOthers");
            }
            if (!(request.getNeedApproveToJoin() == null || rsp.getNeedApproveToJoinUpdated() != null && rsp.getNeedApproveToJoinUpdated().booleanValue())) {
                throw new EMUnknownException("needApproveToJoin");
            }
        }).then();
    }

    public Mono<Void> updateOwner(String groupId, String owner) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().put().uri(String.format("/chatgroups/%s", groupId))).send((Publisher)Mono.create(sink -> sink.success((Object)this.context.getCodec().encode(new UpdateGroupOwnerRequest(owner))))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then());
    }
}

