/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.loadbalance;

import com.easemob.im.server.EMProperties;
import com.easemob.im.server.api.Codec;
import com.easemob.im.server.api.ErrorMapper;
import com.easemob.im.server.api.loadbalance.Endpoint;
import com.easemob.im.server.api.loadbalance.EndpointProvider;
import com.easemob.im.server.api.loadbalance.GetDnsConfigResponse;
import io.netty.buffer.ByteBuf;
import java.util.List;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class DnsConfigEndpointProvider
implements EndpointProvider {
    private final EMProperties properties;
    private final Codec codec;
    private final HttpClient httpClient;
    private final ErrorMapper errorMapper;

    public DnsConfigEndpointProvider(EMProperties properties, Codec codec, HttpClient httpClient, ErrorMapper errorMapper) {
        this.properties = properties;
        this.codec = codec;
        this.httpClient = httpClient;
        this.errorMapper = errorMapper;
    }

    @Override
    public Mono<List<Endpoint>> endpoints() {
        return ((HttpClient.ResponseReceiver)this.httpClient.get().uri(String.format("/easemob/server.json?app_key=%s", this.properties.getAppkeyUrlEncoded()))).responseSingle((rsp, buf) -> this.errorMapper.apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.codec.decode((ByteBuf)buf, GetDnsConfigResponse.class)).map(GetDnsConfigResponse::toEndpoints);
    }
}

