/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.loadbalance;

import com.easemob.im.server.api.loadbalance.Endpoint;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;

public class GetDnsConfigResponse {
    @JsonProperty(value="deploy_name")
    private String name;
    @JsonProperty(value="file_version")
    private String version;
    @JsonProperty(value="rest")
    private Service service;

    @JsonCreator
    public GetDnsConfigResponse(@JsonProperty(value="deploy_name") String name, @JsonProperty(value="file_version") String version, @JsonProperty(value="rest") Service service) {
        this.name = name;
        this.version = version;
        this.service = service;
    }

    public List<Endpoint> toEndpoints() {
        return this.service.toEndpoints();
    }

    public static class ServiceRecord {
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="domain")
        private String domainName;
        @JsonProperty(value="ip")
        private String ip;
        @JsonProperty(value="port")
        private int port;

        public ServiceRecord(@JsonProperty(value="protocol") String protocol, @JsonProperty(value="domain") String domainName, @JsonProperty(value="ip") String ip, @JsonProperty(value="port") int port) {
            this.protocol = protocol;
            this.domainName = domainName;
            this.ip = ip;
            this.port = port;
        }

        public Endpoint toEndpoint() {
            if (this.domainName != null) {
                return new Endpoint(this.protocol, this.domainName, this.port);
            }
            return new Endpoint(this.protocol, this.ip, this.port);
        }
    }

    public static class Service {
        @JsonProperty(value="hosts")
        private List<ServiceRecord> records;

        public Service(@JsonProperty(value="hosts") List<ServiceRecord> records) {
            this.records = records;
        }

        public List<Endpoint> toEndpoints() {
            return this.records.stream().map(ServiceRecord::toEndpoint).collect(Collectors.toList());
        }
    }
}

