/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.loadbalance;

import com.easemob.im.server.api.loadbalance.Endpoint;
import com.easemob.im.server.api.loadbalance.EndpointProvider;
import com.easemob.im.server.api.loadbalance.EndpointRegistry;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.util.retry.Retry;

public class TimedRefreshEndpointRegistry
implements EndpointRegistry {
    private static final Logger log = LoggerFactory.getLogger(TimedRefreshEndpointRegistry.class);
    private final EndpointProvider endpointProvider;
    private final AtomicReference<List<Endpoint>> endpoints;
    private final Disposable refreshDisposable;

    public TimedRefreshEndpointRegistry(EndpointProvider endpointProvider, Duration refreshInterval) {
        this.endpointProvider = endpointProvider;
        this.endpoints = new AtomicReference();
        endpointProvider.endpoints().timeout(Duration.ofSeconds(10L)).doOnNext(this.endpoints::set).doOnError(error -> log.warn("load endpoints error: {}", (Object)error.getMessage())).retryWhen((Retry)Retry.fixedDelay((long)10L, (Duration)Duration.ofSeconds(3L))).doOnError(error -> log.warn("load endpoints error, retry exhausted: {}", (Object)error.getMessage())).block();
        this.refreshDisposable = Flux.interval((Duration)refreshInterval).concatMap(i -> this.endpointProvider.endpoints().doOnNext(this.endpoints::set).then()).retry().subscribe();
    }

    public void close() {
        this.refreshDisposable.dispose();
    }

    @Override
    public List<Endpoint> endpoints() {
        return this.endpoints.get();
    }
}

