/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.message.history;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.message.history.MessageHistoryResponse;
import com.easemob.im.server.api.util.FileSystem;
import io.netty.buffer.ByteBuf;
import java.nio.file.Path;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class MessageHistory {
    private Context context;
    private String timezone;

    public MessageHistory(Context context, String timezone) {
        this.context = context;
        this.timezone = timezone;
    }

    public Mono<String> toUri(Instant instant) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/chatmessages/%s", this.toPath(instant)))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, MessageHistoryResponse.class)).map(MessageHistoryResponse::getUrl);
    }

    public Mono<Path> toLocalFile(Instant instant, Path dir, String filename) {
        if (!dir.toFile().exists()) {
            dir.toFile().mkdirs();
        }
        if (filename == null) {
            filename = this.toPath(instant) + ".gz";
        }
        String finalFilename = filename;
        return this.toUri(instant).flatMap(uri -> {
            Path local = FileSystem.choosePath(dir, finalFilename);
            return Mono.create(sink -> sink.success((Object)FileSystem.open(local))).flatMap(out -> ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(uri)).response((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).thenMany((Publisher)buf)).doOnNext(buf -> FileSystem.append(out, buf)).doFinally(sig -> FileSystem.close(out)).then().thenReturn((Object)local));
        });
    }

    private String toPath(Instant instant) {
        OffsetDateTime dateTime = instant.atOffset(ZoneOffset.of(this.timezone));
        int year = dateTime.getYear();
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        int hour = dateTime.getHour();
        return String.format("%4d%02d%02d%02d", year, month, day, hour);
    }
}

