/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.message.send;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.message.send.SendMessageRequest;
import com.easemob.im.server.api.message.send.SendMessageResponse;
import com.easemob.im.server.model.EMCommandMessage;
import com.easemob.im.server.model.EMCustomMessage;
import com.easemob.im.server.model.EMFileMessage;
import com.easemob.im.server.model.EMImageMessage;
import com.easemob.im.server.model.EMKeyValue;
import com.easemob.im.server.model.EMLocationMessage;
import com.easemob.im.server.model.EMMessage;
import com.easemob.im.server.model.EMSentMessageIds;
import com.easemob.im.server.model.EMTextMessage;
import com.easemob.im.server.model.EMVideoMessage;
import com.easemob.im.server.model.EMVoiceMessage;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class SendMessage {
    private final Context context;

    public SendMessage(Context context) {
        this.context = context;
    }

    public RouteSpec fromUser(String username) {
        return new RouteSpec(username);
    }

    public Mono<EMSentMessageIds> send(String from, String toType, Set<String> tos, EMMessage message, Set<EMKeyValue> extensions) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().post().uri("/messages?useMsgId=true")).send((Publisher)Mono.create(sink -> sink.success((Object)this.context.getCodec().encode(new SendMessageRequest(from, toType, tos, message, SendMessageRequest.parseExtensions(extensions)))))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, SendMessageResponse.class)).map(SendMessageResponse::toEMSentMessages);
    }

    public class SendSpec {
        private String from;
        private String toType;
        private Set<String> tos;
        private EMMessage message;
        private Set<EMKeyValue> extensions;

        SendSpec(String from, String toType, Set<String> tos, EMMessage message) {
            this.from = from;
            this.toType = toType;
            this.tos = tos;
            this.message = message;
        }

        public SendSpec extension(Consumer<Set<EMKeyValue>> customizer) {
            if (this.extensions == null) {
                this.extensions = new HashSet<EMKeyValue>();
            }
            customizer.accept(this.extensions);
            return this;
        }

        public Mono<EMSentMessageIds> send() {
            return SendMessage.this.send(this.from, this.toType, this.tos, this.message, this.extensions);
        }
    }

    public class MessageSpec {
        private String from;
        private String toType;
        private Set<String> tos;

        public MessageSpec(String from, String toType, Set<String> tos) {
            this.from = from;
            this.toType = toType;
            this.tos = tos;
        }

        public SendSpec text(Consumer<EMTextMessage> customizer) {
            EMTextMessage message = new EMTextMessage();
            customizer.accept(message);
            return new SendSpec(this.from, this.toType, this.tos, message);
        }

        public SendSpec image(Consumer<EMImageMessage> customizer) {
            EMImageMessage message = new EMImageMessage();
            customizer.accept(message);
            return new SendSpec(this.from, this.toType, this.tos, message);
        }

        public SendSpec voice(Consumer<EMVoiceMessage> customizer) {
            EMVoiceMessage message = new EMVoiceMessage();
            customizer.accept(message);
            return new SendSpec(this.from, this.toType, this.tos, message);
        }

        public SendSpec video(Consumer<EMVideoMessage> customizer) {
            EMVideoMessage message = new EMVideoMessage();
            customizer.accept(message);
            return new SendSpec(this.from, this.toType, this.tos, message);
        }

        public SendSpec location(Consumer<EMLocationMessage> customizer) {
            EMLocationMessage message = new EMLocationMessage();
            customizer.accept(message);
            return new SendSpec(this.from, this.toType, this.tos, message);
        }

        public SendSpec file(Consumer<EMFileMessage> customizer) {
            EMFileMessage message = new EMFileMessage();
            customizer.accept(message);
            return new SendSpec(this.from, this.toType, this.tos, message);
        }

        public SendSpec command(Consumer<EMCommandMessage> customizer) {
            EMCommandMessage message = new EMCommandMessage();
            customizer.accept(message);
            return new SendSpec(this.from, this.toType, this.tos, message);
        }

        public SendSpec custom(Consumer<EMCustomMessage> customizer) {
            EMCustomMessage message = new EMCustomMessage();
            customizer.accept(message);
            return new SendSpec(this.from, this.toType, this.tos, message);
        }
    }

    public class RouteSpec {
        private String from;

        public RouteSpec(String from) {
            this.from = from;
        }

        public MessageSpec toUser(String username) {
            HashSet<String> tos = new HashSet<String>();
            tos.add(username);
            return new MessageSpec(this.from, "users", tos);
        }

        public MessageSpec toUsers(Set<String> usernames) {
            return new MessageSpec(this.from, "users", usernames);
        }

        public MessageSpec toGroup(String groupId) {
            HashSet<String> tos = new HashSet<String>();
            tos.add(groupId);
            return new MessageSpec(this.from, "chatgroups", tos);
        }

        public MessageSpec toGroups(Set<String> groupIds) {
            return new MessageSpec(this.from, "chatgroups", groupIds);
        }

        public MessageSpec toRoom(String roomId) {
            HashSet<String> tos = new HashSet<String>();
            tos.add(roomId);
            return new MessageSpec(this.from, "chatrooms", tos);
        }

        public MessageSpec toRooms(Set<String> roomIds) {
            return new MessageSpec(this.from, "chatrooms", roomIds);
        }
    }
}

