/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.message.send;

import com.easemob.im.server.model.EMCommandMessage;
import com.easemob.im.server.model.EMCustomMessage;
import com.easemob.im.server.model.EMFileMessage;
import com.easemob.im.server.model.EMImageMessage;
import com.easemob.im.server.model.EMKeyValue;
import com.easemob.im.server.model.EMLocationMessage;
import com.easemob.im.server.model.EMMessage;
import com.easemob.im.server.model.EMTextMessage;
import com.easemob.im.server.model.EMVideoMessage;
import com.easemob.im.server.model.EMVoiceMessage;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
public class SendMessageRequest {
    @JsonProperty(value="from")
    private String from;
    @JsonProperty(value="target_type")
    private String targetType;
    @JsonProperty(value="target")
    private Set<String> targets;
    @JsonProperty(value="msg")
    private Message message;
    @JsonProperty(value="ext")
    private Map<String, Object> extensions;

    @JsonCreator
    public SendMessageRequest(@JsonProperty(value="from") String from, @JsonProperty(value="target_type") String targetType, @JsonProperty(value="target") Set<String> targets, @JsonProperty(value="msg") EMMessage message, @JsonProperty(value="ext") Map<String, Object> extensions) {
        this.from = from;
        this.targetType = targetType;
        this.targets = targets;
        this.message = Message.of(message);
        this.extensions = extensions;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public Message getMessage() {
        return this.message;
    }

    public Set<EMKeyValue> getExtensions() {
        return this.populateExtensions(this.extensions);
    }

    public static Map<String, Object> parseExtensions(Set<EMKeyValue> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return null;
        }
        HashMap<String, Object> mapped = new HashMap<String, Object>();
        for (EMKeyValue keyValue : extensions) {
            switch (keyValue.type()) {
                case BOOL: {
                    mapped.put(keyValue.key(), keyValue.asBoolean());
                    break;
                }
                case INT: {
                    mapped.put(keyValue.key(), keyValue.asInt());
                    break;
                }
                case UINT: {
                    mapped.put(keyValue.key(), keyValue.asLong());
                    break;
                }
                case LLINT: {
                    mapped.put(keyValue.key(), keyValue.asLong());
                    break;
                }
                case FLOAT: {
                    mapped.put(keyValue.key(), keyValue.asFloat());
                    break;
                }
                case DOUBLE: {
                    mapped.put(keyValue.key(), keyValue.asDouble());
                    break;
                }
                case STRING: {
                    mapped.put(keyValue.key(), keyValue.asString());
                    break;
                }
                case JSON_STRING: {
                    mapped.put(keyValue.key(), keyValue.asString());
                }
            }
        }
        return mapped;
    }

    public Set<EMKeyValue> populateExtensions(Map<String, Object> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return null;
        }
        HashSet<EMKeyValue> mapped = new HashSet<EMKeyValue>();
        for (String key : extensions.keySet()) {
            Object value = extensions.get(key);
            if (value instanceof Boolean) {
                mapped.add(EMKeyValue.of(key, (Boolean)value));
                continue;
            }
            if (value instanceof Integer) {
                mapped.add(EMKeyValue.of(key, (Integer)value));
                continue;
            }
            if (value instanceof Long) {
                mapped.add(EMKeyValue.of(key, (Long)value));
                continue;
            }
            if (value instanceof Float) {
                mapped.add(EMKeyValue.of(key, ((Float)value).floatValue()));
                continue;
            }
            if (value instanceof Double) {
                mapped.add(EMKeyValue.of(key, (Double)value));
                continue;
            }
            if (!(value instanceof String)) continue;
            mapped.add(EMKeyValue.of(key, (String)value));
        }
        return mapped;
    }

    static class Dimensions {
        @JsonProperty(value="width")
        private Double width;
        @JsonProperty(value="height")
        private Double height;

        public Double getWidth() {
            return this.width;
        }

        public Double getHeight() {
            return this.height;
        }

        @JsonCreator
        public Dimensions(@JsonProperty(value="width") Double width, @JsonProperty(value="height") Double height) {
            this.width = width;
            this.height = height;
        }
    }

    static class Message {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="msg")
        private String text;
        @JsonProperty(value="lng")
        private Double longitude;
        @JsonProperty(value="lat")
        private Double latitude;
        @JsonProperty(value="addr")
        private String address;
        @JsonProperty(value="filename")
        private String displayName;
        @JsonProperty(value="url")
        private String uri;
        @JsonProperty(value="secret")
        private String secret;
        @JsonProperty(value="file_length")
        private Integer bytes;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="param")
        private Map<String, Object> params;
        @JsonProperty(value="length")
        private Integer duration;
        @JsonProperty(value="size")
        private Dimensions dimensions;
        @JsonProperty(value="thumb")
        private String thumb;
        @JsonProperty(value="thumb_secret")
        private String thumbSecret;
        @JsonProperty(value="customEvent")
        private String customEvent;
        @JsonProperty(value="customExts")
        private Map<String, Object> customExtensions;

        @JsonCreator
        public Message(@JsonProperty(value="type") String type, @JsonProperty(value="msg") String text, @JsonProperty(value="lng") Double longitude, @JsonProperty(value="lat") Double latitude, @JsonProperty(value="addr") String address, @JsonProperty(value="filename") String displayName, @JsonProperty(value="url") String uri, @JsonProperty(value="secret") String secretKey, @JsonProperty(value="file_length") Integer bytes, @JsonProperty(value="action") String action, @JsonProperty(value="param") Map<String, Object> params, @JsonProperty(value="length") Integer duration, @JsonProperty(value="size") Dimensions dimensions, @JsonProperty(value="customEvent") String customEvent, @JsonProperty(value="customExts") Map<String, Object> customExtensions) {
            this.type = type;
            this.text = text;
            this.longitude = longitude;
            this.latitude = latitude;
            this.address = address;
            this.displayName = displayName;
            this.uri = uri;
            this.secret = secretKey;
            this.bytes = bytes;
            this.action = action;
            this.params = params;
            this.duration = duration;
            this.dimensions = dimensions;
            this.customEvent = customEvent;
            this.customExtensions = customExtensions;
        }

        public Message(String type) {
            this.type = type;
        }

        public static Message of(EMMessage msg) {
            switch (msg.messageType()) {
                case TEXT: {
                    return Message.of((EMTextMessage)msg);
                }
                case IMAGE: {
                    return Message.of((EMImageMessage)msg);
                }
                case AUDIO: {
                    return Message.of((EMVoiceMessage)msg);
                }
                case VIDEO: {
                    return Message.of((EMVideoMessage)msg);
                }
                case LOCATION: {
                    return Message.of((EMLocationMessage)msg);
                }
                case FILE: {
                    return Message.of((EMFileMessage)msg);
                }
                case COMMAND: {
                    return Message.of((EMCommandMessage)msg);
                }
                case CUSTOM: {
                    return Message.of((EMCustomMessage)msg);
                }
            }
            throw new IllegalArgumentException(String.format("message type %s not supported", new Object[]{msg.messageType()}));
        }

        public static Message of(EMTextMessage msg) {
            Message send = new Message("text");
            send.text = msg.text();
            return send;
        }

        public static Message of(EMImageMessage msg) {
            Message send = new Message("img");
            send.uri = msg.uri() == null ? null : msg.uri().toString();
            send.displayName = msg.displayName();
            send.bytes = msg.bytes();
            send.secret = msg.secret();
            if (msg.width() != null || msg.height() != null) {
                send.dimensions = new Dimensions(msg.width(), msg.height());
            }
            return send;
        }

        public static Message of(EMVoiceMessage msg) {
            Message send = new Message("audio");
            send.uri = msg.uri() == null ? null : msg.uri().toString();
            send.displayName = msg.displayName();
            send.bytes = msg.bytes();
            send.secret = msg.secret();
            send.duration = msg.duration();
            return send;
        }

        public static Message of(EMVideoMessage msg) {
            Message send = new Message("video");
            send.uri = msg.uri() == null ? null : msg.uri().toString();
            send.displayName = msg.displayName();
            send.bytes = msg.bytes();
            send.secret = msg.secret();
            send.duration = msg.duration();
            send.thumb = msg.thumb();
            send.thumbSecret = msg.thumbSecret();
            return send;
        }

        public static Message of(EMLocationMessage msg) {
            Message send = new Message("loc");
            send.longitude = msg.longitude();
            send.latitude = msg.latitude();
            send.address = msg.address();
            return send;
        }

        public static Message of(EMFileMessage msg) {
            Message send = new Message("file");
            send.uri = msg.uri() == null ? null : msg.uri().toString();
            send.displayName = msg.displayName();
            send.bytes = msg.bytes();
            send.secret = msg.secret();
            return send;
        }

        public static Message of(EMCommandMessage msg) {
            Message send = new Message("cmd");
            send.action = msg.action();
            if (msg.params() == null) {
                return send;
            }
            send.params = new HashMap<String, Object>();
            for (EMKeyValue kv : msg.params()) {
                switch (kv.type()) {
                    case BOOL: {
                        send.params.put(kv.key(), kv.asBoolean());
                        break;
                    }
                    case INT: {
                        send.params.put(kv.key(), kv.asInt());
                        break;
                    }
                    case UINT: {
                        send.params.put(kv.key(), kv.asLong());
                        break;
                    }
                    case LLINT: {
                        send.params.put(kv.key(), kv.asLong());
                        break;
                    }
                    case FLOAT: {
                        send.params.put(kv.key(), kv.asFloat());
                        break;
                    }
                    case DOUBLE: {
                        send.params.put(kv.key(), kv.asDouble());
                        break;
                    }
                    case STRING: {
                        send.params.put(kv.key(), kv.asString());
                        break;
                    }
                    case JSON_STRING: {
                        send.params.put(kv.key(), kv.asString());
                    }
                }
            }
            return send;
        }

        public static Message of(EMCustomMessage msg) {
            Message send = new Message("custom");
            send.customEvent = msg.customEvent();
            if (msg.customExtensions() == null) {
                return send;
            }
            send.customExtensions = new HashMap<String, Object>();
            for (EMKeyValue kv : msg.customExtensions()) {
                switch (kv.type()) {
                    case BOOL: {
                        send.customExtensions.put(kv.key(), kv.asBoolean());
                        break;
                    }
                    case INT: {
                        send.customExtensions.put(kv.key(), kv.asInt());
                        break;
                    }
                    case UINT: {
                        send.customExtensions.put(kv.key(), kv.asLong());
                        break;
                    }
                    case LLINT: {
                        send.customExtensions.put(kv.key(), kv.asLong());
                        break;
                    }
                    case FLOAT: {
                        send.customExtensions.put(kv.key(), kv.asFloat());
                        break;
                    }
                    case DOUBLE: {
                        send.customExtensions.put(kv.key(), kv.asDouble());
                        break;
                    }
                    case STRING: {
                        send.customExtensions.put(kv.key(), kv.asString());
                        break;
                    }
                    case JSON_STRING: {
                        send.customExtensions.put(kv.key(), kv.asString());
                    }
                }
            }
            return send;
        }
    }
}

