/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.room;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.room.admin.demote.DemoteRoomAdmin;
import com.easemob.im.server.api.room.admin.list.ListRoomAdmins;
import com.easemob.im.server.api.room.admin.promote.PromoteRoomAdmin;
import com.easemob.im.server.api.room.create.CreateRoom;
import com.easemob.im.server.api.room.delete.DeleteRoom;
import com.easemob.im.server.api.room.detail.GetRoomDetail;
import com.easemob.im.server.api.room.list.ListRooms;
import com.easemob.im.server.api.room.member.add.AddRoomMember;
import com.easemob.im.server.api.room.member.list.ListRoomMembers;
import com.easemob.im.server.api.room.member.remove.RemoveRoomMember;
import com.easemob.im.server.api.room.superadmin.demote.DemoteRoomSuperAdmin;
import com.easemob.im.server.api.room.superadmin.list.ListRoomSuperAdmins;
import com.easemob.im.server.api.room.superadmin.promote.PromoteRoomSuperAdmin;
import com.easemob.im.server.api.room.update.UpdateRoom;
import com.easemob.im.server.api.room.update.UpdateRoomRequest;
import com.easemob.im.server.model.EMPage;
import com.easemob.im.server.model.EMRoom;
import java.util.List;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RoomApi {
    private CreateRoom createRoom;
    private GetRoomDetail getRoomDetail;
    private UpdateRoom updateRoom;
    private ListRooms listRooms;
    private ListRoomMembers listRoomMembers;
    private AddRoomMember addRoomMember;
    private RemoveRoomMember removeRoomMember;
    private ListRoomAdmins listRoomAdmins;
    private PromoteRoomAdmin promoteRoomAdmin;
    private DemoteRoomAdmin demoteRoomAdmin;
    private ListRoomSuperAdmins listRoomSuperAdmins;
    private PromoteRoomSuperAdmin promoteRoomSuperAdmin;
    private DemoteRoomSuperAdmin demoteRoomSuperAdmin;
    private DeleteRoom deleteRoom;

    public RoomApi(Context context) {
        this.createRoom = new CreateRoom(context);
        this.getRoomDetail = new GetRoomDetail(context);
        this.updateRoom = new UpdateRoom(context);
        this.listRooms = new ListRooms(context);
        this.listRoomMembers = new ListRoomMembers(context);
        this.addRoomMember = new AddRoomMember(context);
        this.removeRoomMember = new RemoveRoomMember(context);
        this.listRoomAdmins = new ListRoomAdmins(context);
        this.promoteRoomAdmin = new PromoteRoomAdmin(context);
        this.demoteRoomAdmin = new DemoteRoomAdmin(context);
        this.listRoomSuperAdmins = new ListRoomSuperAdmins(context);
        this.promoteRoomSuperAdmin = new PromoteRoomSuperAdmin(context);
        this.demoteRoomSuperAdmin = new DemoteRoomSuperAdmin(context);
        this.deleteRoom = new DeleteRoom(context);
    }

    public Mono<String> createRoom(String name, String description, String owner, List<String> members, int maxMembers) {
        return this.createRoom.createRoom(name, description, owner, members, maxMembers);
    }

    public Mono<EMRoom> getRoom(String id) {
        return this.getRoomDetail.byId(id);
    }

    public Mono<Void> updateRoom(String id, Consumer<UpdateRoomRequest> customizer) {
        return this.updateRoom.byId(id, customizer);
    }

    public Flux<String> listRoomsAll() {
        return this.listRooms.all(10);
    }

    public Mono<EMPage<String>> listRooms(int limit, String cursor) {
        return this.listRooms.next(limit, cursor);
    }

    public Flux<String> listRoomsUserJoined(String username) {
        return this.listRooms.userJoined(username);
    }

    public Flux<String> listRoomMembersAll(String roomId) {
        return this.listRoomMembers.all(roomId, 10);
    }

    public Mono<EMPage<String>> listRoomMembers(String roomId, int limit, String cursor) {
        return this.listRoomMembers.next(roomId, limit, cursor);
    }

    public Mono<Void> addRoomMember(String roomId, String username) {
        return this.addRoomMember.single(roomId, username);
    }

    public Mono<Void> removeRoomMember(String roomId, String username) {
        return this.removeRoomMember.single(roomId, username);
    }

    public Flux<String> listRoomAdminsAll(String roomId) {
        return this.listRoomAdmins.all(roomId);
    }

    public Mono<Void> promoteRoomAdmin(String roomId, String username) {
        return this.promoteRoomAdmin.single(roomId, username);
    }

    public Mono<Void> demoteRoomAdmin(String roomId, String username) {
        return this.demoteRoomAdmin.single(roomId, username);
    }

    public Flux<String> listRoomSuperAdminsAll() {
        return this.listRoomSuperAdmins.all(10);
    }

    public Mono<Void> promoteRoomSuperAdmin(String username) {
        return this.promoteRoomSuperAdmin.single(username);
    }

    public Mono<Void> demoteRoomSuperAdmin(String username) {
        return this.demoteRoomSuperAdmin.singnle(username);
    }

    public Mono<Void> destroyRoom(String roomId) {
        return this.deleteRoom.byId(roomId);
    }
}

