/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.room.detail;

import com.easemob.im.server.model.EMRoom;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;

public class GetRoomDetailResponse {
    @JsonProperty(value="data")
    private List<Room> rooms;

    public GetRoomDetailResponse(@JsonProperty(value="data") List<Room> rooms) {
        this.rooms = rooms;
    }

    public List<EMRoom> toRoomDetails() {
        return this.rooms.stream().map(Room::toRoom).collect(Collectors.toList());
    }

    private static class Room {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="membersonly")
        private boolean needApprove;
        @JsonProperty(value="owner")
        private String owner;
        @JsonProperty(value="maxusers")
        private int maxMembers;

        @JsonCreator
        public Room(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="owner") String owner, @JsonProperty(value="membersonly") boolean needApprove, @JsonProperty(value="maxusers") int maxMembers) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.owner = owner;
            this.needApprove = needApprove;
            this.maxMembers = maxMembers;
        }

        public EMRoom toRoom() {
            return new EMRoom(this.id, this.name, this.description, this.needApprove, this.owner, this.maxMembers);
        }
    }
}

