/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.room.list;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.room.list.ListRoomsResponse;
import com.easemob.im.server.model.EMPage;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class ListRooms {
    private Context context;

    public ListRooms(Context context) {
        this.context = context;
    }

    public Flux<String> all(int limit) {
        return this.next(limit, null).expand(rsp -> rsp.getCursor() == null ? Mono.empty() : this.next(limit, rsp.getCursor())).concatMapIterable(EMPage::getValues);
    }

    public Mono<EMPage<String>> next(int limit, String cursor) {
        String uri = String.format("/chatrooms?limit=%d", limit);
        if (cursor != null) {
            uri = uri + String.format("&cursor=%s", cursor);
        }
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(uri)).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, ListRoomsResponse.class)).map(ListRoomsResponse::toEMPage);
    }

    public Flux<String> userJoined(String username) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/users/%s/joined_chatrooms", username))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, ListRoomsResponse.class)).flatMapIterable(ListRoomsResponse::getRoomIds);
    }
}

