/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.room.list;

import com.easemob.im.server.model.EMPage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;

public class ListRoomsResponse {
    @JsonProperty(value="data")
    private List<Room> rooms;
    @JsonProperty(value="cursor")
    private String cursor;

    public List<String> getRoomIds() {
        return this.rooms.stream().map(Room::getId).collect(Collectors.toList());
    }

    public String getCursor() {
        return this.cursor;
    }

    public EMPage<String> toEMPage() {
        List roomIds = this.rooms.stream().map(Room::getId).collect(Collectors.toList());
        return new EMPage<String>(roomIds, this.cursor);
    }

    @JsonCreator
    public ListRoomsResponse(@JsonProperty(value="data") List<Room> rooms) {
        this.rooms = rooms;
    }

    public static class Room {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="owner")
        private String owner;
        @JsonProperty(value="affiliations_count")
        private int members;

        @JsonCreator
        public Room(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="owner") String owner, @JsonProperty(value="affiliations_count") int members) {
            this.id = id;
            this.name = name;
            this.owner = owner;
            this.members = members;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getOwner() {
            return this.owner;
        }

        public int getMembers() {
            return this.members;
        }
    }
}

