/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.room.member.list;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.room.member.list.ListRoomMembersResponse;
import com.easemob.im.server.model.EMPage;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class ListRoomMembers {
    private Context context;

    public ListRoomMembers(Context context) {
        this.context = context;
    }

    public Flux<String> all(String roomId, int limit) {
        return this.next(roomId, limit, null).expand(rsp -> rsp.getCursor() == null ? Mono.empty() : this.next(roomId, limit, rsp.getCursor())).concatMapIterable(EMPage::getValues);
    }

    public Mono<EMPage<String>> next(String roomId, int limit, String cursor) {
        String uri = String.format("/chatrooms/%s/users?version=v3&limit=%d", roomId, limit);
        if (cursor != null) {
            uri = uri + String.format("&cursor=%s", cursor);
        }
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(uri)).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, ListRoomMembersResponse.class)).map(ListRoomMembersResponse::toEMPage);
    }
}

