/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.room.update;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.room.update.UpdateRoomRequest;
import com.easemob.im.server.api.room.update.UpdateRoomResponse;
import com.easemob.im.server.exception.EMUnknownException;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class UpdateRoom {
    private Context context;

    public UpdateRoom(Context context) {
        this.context = context;
    }

    public Mono<Void> byId(String id, Consumer<UpdateRoomRequest> customizer) {
        UpdateRoomRequest request = new UpdateRoomRequest();
        customizer.accept(request);
        return ((HttpClient.RequestSender)this.context.getHttpClient().put().uri(String.format("/chatrooms/%s", id))).send((Publisher)Mono.create(sink -> sink.success((Object)this.context.getCodec().encode(request)))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, UpdateRoomResponse.class)).handle((rsp, sink) -> {
            ArrayList<String> notUpdated = new ArrayList<String>();
            if (request.hasName() && !rsp.nameUpdated()) {
                notUpdated.add("name");
            }
            if (request.hasDescription() && !rsp.descriptionUpdated()) {
                notUpdated.add("description");
            }
            if (request.hasMaxMembers() && !rsp.maxMembersUpdated()) {
                notUpdated.add("maxMembers");
            }
            if (!notUpdated.isEmpty()) {
                sink.error((Throwable)new EMUnknownException(String.format("%s not updated", String.join((CharSequence)",", notUpdated))));
                return;
            }
            sink.complete();
        });
    }
}

