/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.token.allocate;

import com.easemob.im.server.api.token.allocate.TokenRequest;
import com.easemob.im.server.exception.EMInvalidArgumentException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class UserTokenRequest
implements TokenRequest {
    @JsonProperty(value="grant_type")
    private final String grantType = "password";
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;

    public String getGrantType() {
        return "password";
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @JsonCreator
    public static UserTokenRequest of(@JsonProperty(value="username") String username, @JsonProperty(value="password") String password) {
        if (username == null || username.isEmpty()) {
            throw new EMInvalidArgumentException("username must not be null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new EMInvalidArgumentException("password must not be null or empty");
        }
        return new UserTokenRequest(username, password);
    }

    private UserTokenRequest(String username, String password) {
        this.username = username;
        this.password = password;
    }
}

