/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.user;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.user.create.CreateUser;
import com.easemob.im.server.api.user.forcelogout.ForceLogoutUser;
import com.easemob.im.server.api.user.get.UserGet;
import com.easemob.im.server.api.user.list.ListUsers;
import com.easemob.im.server.api.user.password.UpdateUserPassword;
import com.easemob.im.server.api.user.status.UserStatus;
import com.easemob.im.server.api.user.unregister.DeleteUser;
import com.easemob.im.server.exception.EMInvalidArgumentException;
import com.easemob.im.server.model.EMPage;
import com.easemob.im.server.model.EMUser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UserApi {
    private CreateUser createUser;
    private DeleteUser deleteUser;
    private ListUsers listUsers;
    private UpdateUserPassword updateUserPassword;
    private ForceLogoutUser forceLogoutUser;
    private UserStatus userStatus;
    private UserGet userGet;

    public UserApi(Context context) {
        this.createUser = new CreateUser(context);
        this.deleteUser = new DeleteUser(context);
        this.listUsers = new ListUsers(context);
        this.updateUserPassword = new UpdateUserPassword(context);
        this.forceLogoutUser = new ForceLogoutUser(context);
        this.userStatus = new UserStatus(context);
        this.userGet = new UserGet(context);
    }

    public Mono<Void> create(String username, String password) {
        try {
            EMUser.validateUsername(username);
            EMUser.validatePassword(password);
        }
        catch (EMInvalidArgumentException e) {
            return Mono.error((Throwable)e);
        }
        return this.createUser.single(username, password);
    }

    public Mono<Void> delete(String username) {
        return this.deleteUser.single(username);
    }

    public Flux<String> listAllUsers() {
        return this.listUsers.all(20);
    }

    public Mono<EMPage<String>> listUsers(int limit, String cursor) {
        return this.listUsers.next(limit, cursor);
    }

    public Flux<String> deleteAll() {
        return this.deleteUser.all(20);
    }

    public Mono<EMUser> get(String username) {
        return this.userGet.single(username);
    }

    public Mono<Void> updateUserPassword(String username, String password) {
        try {
            EMUser.validatePassword(password);
        }
        catch (EMInvalidArgumentException e) {
            return Mono.error((Throwable)e);
        }
        return this.updateUserPassword.update(username, password);
    }

    public Mono<Void> forceLogoutAllDevices(String username) {
        return this.forceLogoutUser.byUsername(username);
    }

    public Mono<Void> forceLogoutOneDevice(String username, String resource) {
        return this.forceLogoutUser.byUsernameAndResource(username, resource);
    }

    public Mono<Boolean> isUserOnline(String username) {
        return this.userStatus.isUserOnline(username);
    }
}

