/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.user.get;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.user.get.UserGetResponse;
import com.easemob.im.server.exception.EMUnknownException;
import com.easemob.im.server.model.EMUser;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class UserGet {
    private Context context;

    public UserGet(Context context) {
        this.context = context;
    }

    public Mono<EMUser> single(String username) {
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/users/%s", username))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, UserGetResponse.class)).handle((rsp, sink) -> {
            EMUser user = rsp.getEMUser(username);
            if (user == null) {
                sink.error((Throwable)new EMUnknownException(String.format("user:%s", username)));
                return;
            }
            sink.next((Object)user);
        });
    }
}

