/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.user.list;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.user.list.UserListResponse;
import com.easemob.im.server.model.EMPage;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class ListUsers {
    private Context context;

    public ListUsers(Context context) {
        this.context = context;
    }

    public Flux<String> all(int limit) {
        return this.next(limit, null).expand(rsp -> rsp.getCursor() == null ? Mono.empty() : this.next(limit, rsp.getCursor())).limitRate(1).concatMapIterable(EMPage::getValues).limitRate(limit);
    }

    public Mono<EMPage<String>> next(int limit, String cursor) {
        String query = String.format("limit=%d", limit);
        if (cursor != null) {
            query = String.format("%s&cursor=%s", query, cursor);
        }
        return ((HttpClient.ResponseReceiver)this.context.getHttpClient().get().uri(String.format("/users?%s", query))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(buf -> this.context.getCodec().decode((ByteBuf)buf, UserListResponse.class)).map(UserListResponse::toEMPage);
    }
}

