/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.api.user.unregister;

import com.easemob.im.server.api.Context;
import com.easemob.im.server.api.user.unregister.UserUnregisterResponse;
import com.easemob.im.server.exception.EMUnknownException;
import io.netty.buffer.ByteBuf;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class DeleteUser {
    private Context context;

    public DeleteUser(Context context) {
        this.context = context;
    }

    public Mono<Void> single(String username) {
        return ((HttpClient.RequestSender)this.context.getHttpClient().delete().uri(String.format("/users/%s", username))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(b -> this.context.getCodec().decode((ByteBuf)b, UserUnregisterResponse.class)).handle((rsp, sink) -> {
            if (rsp.getError() != null) {
                sink.error((Throwable)new EMUnknownException(rsp.getError()));
                return;
            }
            sink.complete();
        });
    }

    public Flux<String> all(int limit) {
        return this.next(limit, null).expand(rsp -> rsp.getCursor() == null ? Mono.empty() : this.next(limit, rsp.getCursor())).concatMapIterable(UserUnregisterResponse::getUsernames);
    }

    public Mono<UserUnregisterResponse> next(int limit, String cursor) {
        String query = String.format("limit=%d", limit);
        if (cursor != null) {
            query = String.format("%s&cursor=%s", query, cursor);
        }
        return ((HttpClient.RequestSender)this.context.getHttpClient().delete().uri(String.format("/users?%s", query))).responseSingle((rsp, buf) -> this.context.getErrorMapper().apply((HttpClientResponse)rsp).then((Mono)buf)).map(b -> this.context.getCodec().decode((ByteBuf)b, UserUnregisterResponse.class));
    }
}

