/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.im.server.model;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class EMKeyValue {
    private final String key;
    private final Type type;
    private final Object value;

    private EMKeyValue(String key, Type type, Object value) {
        this.key = key;
        this.type = type;
        this.value = value;
    }

    public static EMKeyValue of(String key, boolean value) {
        return new EMKeyValue(key, Type.BOOL, value);
    }

    public static EMKeyValue of(String key, int value) {
        return new EMKeyValue(key, Type.INT, value);
    }

    public static EMKeyValue of(String key, long value) {
        return new EMKeyValue(key, Type.LLINT, value);
    }

    public static EMKeyValue of(String key, float value) {
        return new EMKeyValue(key, Type.FLOAT, Float.valueOf(value));
    }

    public static EMKeyValue of(String key, double value) {
        return new EMKeyValue(key, Type.DOUBLE, value);
    }

    public static EMKeyValue of(String key, String value) {
        return new EMKeyValue(key, Type.STRING, value);
    }

    public static EMKeyValue of(String k, Object v) {
        if (v instanceof Boolean) {
            return EMKeyValue.of(k, (Boolean)v);
        }
        if (v instanceof Integer) {
            return EMKeyValue.of(k, (Integer)v);
        }
        if (v instanceof Long) {
            return EMKeyValue.of(k, (Long)v);
        }
        if (v instanceof Float) {
            return EMKeyValue.of(k, ((Float)v).floatValue());
        }
        if (v instanceof Double) {
            return EMKeyValue.of(k, (Double)v);
        }
        if (v instanceof String) {
            return EMKeyValue.of(k, (String)v);
        }
        throw new IllegalArgumentException("can not convert the type: " + v.getClass());
    }

    public static Set<EMKeyValue> of(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return new LinkedHashSet<EMKeyValue>();
        }
        LinkedHashSet<EMKeyValue> emKeyValues = new LinkedHashSet<EMKeyValue>(map.size());
        map.forEach((k, v) -> emKeyValues.add(EMKeyValue.of(k, v)));
        return emKeyValues;
    }

    public String key() {
        return this.key;
    }

    public Type type() {
        return this.type;
    }

    public boolean asBoolean() {
        return (Boolean)this.value;
    }

    public int asInt() {
        return (Integer)this.value;
    }

    public long asLong() {
        return (Long)this.value;
    }

    public long asFloat() {
        return (Long)this.value;
    }

    public double asDouble() {
        return (Double)this.value;
    }

    public String asString() {
        return (String)this.value;
    }

    public Object asObject() {
        return this.value;
    }

    public static enum Type {
        BOOL,
        INT,
        UINT,
        LLINT,
        FLOAT,
        DOUBLE,
        STRING,
        JSON_STRING;

    }
}

