/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52;

import java.util.Properties;
import lombok.NonNull;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.client.RedisClientFactory;
import org.hibernate.cache.redis.hibernate52.ConfigurableRedisRegionFactory;
import org.hibernate.cache.redis.hibernate52.regions.RedisCollectionRegion;
import org.hibernate.cache.redis.hibernate52.regions.RedisEntityRegion;
import org.hibernate.cache.redis.hibernate52.regions.RedisNaturalIdRegion;
import org.hibernate.cache.redis.hibernate52.regions.RedisQueryResultsRegion;
import org.hibernate.cache.redis.hibernate52.regions.RedisTimestampsRegion;
import org.hibernate.cache.redis.hibernate52.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.redis.hibernate52.strategy.RedisAccessStrategyFactoryImpl;
import org.hibernate.cache.redis.util.CacheTimestamper;
import org.hibernate.cache.redis.util.RedisCacheUtil;
import org.hibernate.cache.redis.util.Timestamper;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRedisRegionFactory
implements RegionFactory,
ConfigurableRedisRegionFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisRegionFactory.class);
    protected final Properties props;
    protected SessionFactoryOptions options;
    protected final RedisAccessStrategyFactory accessStrategyFactory = new RedisAccessStrategyFactoryImpl();
    protected volatile RedisClient redis = null;
    protected CacheTimestamper cacheTimestamper = null;
    private static final long serialVersionUID = 4244155609146774509L;

    protected AbstractRedisRegionFactory(@NonNull Properties props) {
        if (props == null) {
            throw new NullPointerException("props");
        }
        this.props = props;
    }

    @Override
    public CacheTimestamper createCacheTimestamper(RedisClient redisClient, String cacheKey) {
        return new Timestamper();
    }

    public RedisClient createRedisClient() {
        return RedisClientFactory.createRedisClient(RedisCacheUtil.getRedissonConfigPath());
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }

    public long nextTimestamp() {
        return this.cacheTimestamper.next();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new RedisEntityRegion(this.accessStrategyFactory, this.redis, this, regionName, this.options, metadata, properties);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new RedisNaturalIdRegion(this.accessStrategyFactory, this.redis, this, regionName, this.options, metadata, properties);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new RedisCollectionRegion(this.accessStrategyFactory, this.redis, this, regionName, this.options, metadata, properties);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new RedisQueryResultsRegion(this.accessStrategyFactory, this.redis, this, regionName, properties);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new RedisTimestampsRegion(this.accessStrategyFactory, this.redis, this, regionName, properties);
    }
}

