/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52;

import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.hibernate52.AbstractRedisRegionFactory;
import org.hibernate.cache.redis.util.RedisCacheUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisRegionFactory
extends AbstractRedisRegionFactory {
    private static final Logger log = LoggerFactory.getLogger(RedisRegionFactory.class);
    private final Object $lock = new Object[0];
    private static final long serialVersionUID = -6772837841732399223L;

    public RedisRegionFactory(Properties props) {
        super(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(SessionFactoryOptions options, Properties properties) throws CacheException {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("RedisRegionFactory is starting... options={}, properties={}", (Object)options, (Object)properties);
            this.options = options;
            try {
                if (this.redis == null) {
                    RedisCacheUtil.loadCacheProperties(this.props);
                    this.redis = this.createRedisClient();
                    this.cacheTimestamper = this.createCacheTimestamper(this.redis, RedisRegionFactory.class.getName());
                }
                log.info("RedisRegionFactory is started.");
            }
            catch (Exception e) {
                log.error("Fail to start RedisRegionFactory.", (Throwable)e);
                throw new CacheException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.redis == null) {
                return;
            }
            log.debug("Stopping RedisRegionFactory...");
            try {
                this.redis.shutdown();
                this.redis = null;
                this.cacheTimestamper = null;
                log.info("RedisRegionFactory is stopped.");
            }
            catch (Exception ignored) {
                log.error("Fail to stop RedisRegionFactory.", (Throwable)ignored);
            }
        }
    }
}

