/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.hibernate52.regions.RedisTransactionalDataRegion;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRedisAccessStrategy<T extends RedisTransactionalDataRegion> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisAccessStrategy.class);
    protected final T region;
    protected final SessionFactoryOptions options;

    AbstractRedisAccessStrategy(T region, SessionFactoryOptions options) {
        this.region = region;
        this.options = options;
    }

    protected SessionFactoryOptions options() {
        return this.options;
    }

    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) {
        return ((RedisTransactionalDataRegion)this.region).get(key);
    }

    public final boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, this.options.isMinimalPutsEnabled());
    }

    abstract boolean putFromLoad(SharedSessionContractImplementor var1, Object var2, Object var3, long var4, Object var6, boolean var7) throws CacheException;

    public final SoftLock lockRegion() {
        return null;
    }

    public final void unlockRegion(SoftLock lock) {
        ((RedisTransactionalDataRegion)this.region).clear();
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        ((RedisTransactionalDataRegion)this.region).remove(key);
    }

    public final void removeAll() {
        ((RedisTransactionalDataRegion)this.region).clear();
    }

    public final void evict(Object key) {
        ((RedisTransactionalDataRegion)this.region).remove(key);
    }

    public final void evictAll() {
        ((RedisTransactionalDataRegion)this.region).clear();
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        ((RedisTransactionalDataRegion)this.region).remove(key);
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        ((RedisTransactionalDataRegion)this.region).remove(key);
    }
}

