/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.redis.hibernate52.regions.RedisCollectionRegion;
import org.hibernate.cache.redis.hibernate52.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRedisCollectionRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisCollectionRegion>
implements CollectionRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyRedisCollectionRegionAccessStrategy.class);

    public ReadOnlyRedisCollectionRegionAccessStrategy(RedisCollectionRegion region, SessionFactoryOptions options) {
        super(region, options);
    }

    public Object generateCacheKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.createCollectionKey((Object)id, (CollectionPersister)persister, (SessionFactoryImplementor)factory, (String)tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return DefaultCacheKeysFactory.getCollectionId((Object)cacheKey);
    }

    public CollectionRegion getRegion() {
        return (CollectionRegion)this.region;
    }

    @Override
    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) {
        return ((RedisCollectionRegion)this.region).get(key);
    }

    @Override
    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisCollectionRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisCollectionRegion)this.region).put(key, value);
        return true;
    }

    @Override
    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) {
        return null;
    }

    @Override
    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) {
    }
}

