/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.service.FakeValuesServiceInterface;
import com.github.javafaker.service.RandomService;
import java.text.DecimalFormat;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class Commerce {
    private final FakeValuesServiceInterface fakeValuesService;
    private final RandomService randomService;

    public Commerce(FakeValuesServiceInterface fakeValuesService, RandomService randomService) {
        this.fakeValuesService = fakeValuesService;
        this.randomService = randomService;
    }

    public String color() {
        return this.fakeValuesService.fetchString("color.name");
    }

    public String department() {
        int numberOfDepartments = Math.max(this.randomService.nextInt(4), 1);
        TreeSet<String> departments = new TreeSet<String>();
        while (departments.size() < numberOfDepartments) {
            departments.add(this.fakeValuesService.fetchString("commerce.department"));
        }
        if (departments.size() > 1) {
            String lastDepartment = (String)departments.last();
            return StringUtils.join(departments.headSet(lastDepartment), (String)", ") + " & " + lastDepartment;
        }
        return (String)departments.first();
    }

    public String productName() {
        return StringUtils.join((Object[])new String[]{this.fakeValuesService.fetchString("commerce.product_name.adjective"), this.fakeValuesService.fetchString("commerce.product_name.material"), this.fakeValuesService.fetchString("commerce.product_name.product")}, (String)" ");
    }

    public String material() {
        return this.fakeValuesService.fetchString("commerce.product_name.material");
    }

    public String price() {
        return this.price(0.0, 100.0);
    }

    public String price(double min, double max) {
        double price = min + this.randomService.nextDouble() * (max - min);
        return new DecimalFormat("#0.00").format(price);
    }
}

