/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Resolver;
import com.github.javafaker.service.FakeValuesServiceInterface;
import com.github.javafaker.service.RandomService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Company {
    private final FakeValuesServiceInterface fakeValuesService;
    private final Resolver resolver;
    private final RandomService randomService;

    public Company(Resolver resolver, FakeValuesServiceInterface fakeValuesService, RandomService randomService) {
        this.fakeValuesService = fakeValuesService;
        this.resolver = resolver;
        this.randomService = randomService;
    }

    public String name() {
        return this.fakeValuesService.resolve("company.name", this, this.resolver);
    }

    public String suffix() {
        return this.fakeValuesService.safeFetch("company.suffix");
    }

    public String industry() {
        return this.fakeValuesService.safeFetch("company.industry");
    }

    public String profession() {
        return this.fakeValuesService.safeFetch("company.profession");
    }

    public String buzzword() {
        List buzzwordLists = (List)this.fakeValuesService.fetchObject("company.buzzwords");
        ArrayList buzzwords = new ArrayList();
        for (List buzzwordList : buzzwordLists) {
            buzzwords.addAll(buzzwordList);
        }
        return (String)buzzwords.get(this.randomService.nextInt(buzzwords.size()));
    }

    public String catchPhrase() {
        List catchPhraseLists = (List)this.fakeValuesService.fetchObject("company.buzzwords");
        return this.joinSampleOfEachList(catchPhraseLists, " ");
    }

    public String bs() {
        List buzzwordLists = (List)this.fakeValuesService.fetchObject("company.bs");
        return this.joinSampleOfEachList(buzzwordLists, " ");
    }

    public String logo() {
        int number = this.randomService.nextInt(13) + 1;
        return "https://pigment.github.io/fake-logos/logos/medium/color/" + number + ".png";
    }

    private String joinSampleOfEachList(List<List<String>> listOfLists, String separator) {
        ArrayList<String> words = new ArrayList<String>();
        for (List<String> list : listOfLists) {
            words.add(list.get(this.randomService.nextInt(list.size())));
        }
        return StringUtils.join(words, (String)separator);
    }
}

