/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Address;
import com.github.javafaker.App;
import com.github.javafaker.Beer;
import com.github.javafaker.Book;
import com.github.javafaker.Bool;
import com.github.javafaker.Business;
import com.github.javafaker.ChuckNorris;
import com.github.javafaker.Code;
import com.github.javafaker.Color;
import com.github.javafaker.Commerce;
import com.github.javafaker.Company;
import com.github.javafaker.Crypto;
import com.github.javafaker.DateAndTime;
import com.github.javafaker.Educator;
import com.github.javafaker.Finance;
import com.github.javafaker.Hacker;
import com.github.javafaker.IdNumber;
import com.github.javafaker.Internet;
import com.github.javafaker.Lorem;
import com.github.javafaker.Name;
import com.github.javafaker.Number;
import com.github.javafaker.Options;
import com.github.javafaker.PhoneNumber;
import com.github.javafaker.Resolver;
import com.github.javafaker.Shakespeare;
import com.github.javafaker.Superhero;
import com.github.javafaker.Team;
import com.github.javafaker.University;
import com.github.javafaker.service.DefaultingFakeValuesService;
import com.github.javafaker.service.FakeValuesService;
import com.github.javafaker.service.FakeValuesServiceInterface;
import com.github.javafaker.service.RandomService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public class Faker
implements Resolver {
    private final RandomService randomService;
    private final FakeValuesService fakeValuesService;
    private final App app;
    private final Lorem lorem;
    private final Name name;
    private final Number number;
    private final Internet internet;
    private final PhoneNumber phoneNumber;
    private final Address address;
    private final Business business;
    private final Book book;
    private final ChuckNorris chuckNorris;
    private final Color color;
    private final Commerce commerce;
    private final Company company;
    private final Crypto crypto;
    private final IdNumber idNumber;
    private final Hacker hacker;
    private final Options options;
    private final Code code;
    private final Finance finance;
    private final DateAndTime dateAndTime;
    private final Educator educator;
    private final Shakespeare shakespeare;
    private final Superhero superhero;
    private final Bool bool;
    private final Team team;
    private final Beer beer;
    private final University university;

    public Faker() {
        this(Locale.ENGLISH);
    }

    public Faker(Locale locale) {
        this(locale, null);
    }

    public Faker(Random random) {
        this(Locale.ENGLISH, random);
    }

    public Faker(Locale locale, Random random) {
        this.randomService = new RandomService(random);
        this.fakeValuesService = new FakeValuesService(locale, this.randomService);
        FakeValuesService defaultEnglishFakeValuesService = new FakeValuesService(Locale.ENGLISH, this.randomService);
        FakeValuesServiceInterface proxiedFakeValueService = Faker.createProxiedFakeValuesService(this.fakeValuesService, defaultEnglishFakeValuesService);
        this.app = new App(this, proxiedFakeValueService);
        this.lorem = new Lorem(proxiedFakeValueService, this.randomService);
        this.name = new Name(this, proxiedFakeValueService);
        this.number = new Number(this.randomService);
        this.internet = new Internet(this.name, this.lorem, proxiedFakeValueService, this.randomService);
        this.phoneNumber = new PhoneNumber(proxiedFakeValueService);
        this.address = new Address(this, this.name, proxiedFakeValueService, this.randomService);
        this.book = new Book(this, proxiedFakeValueService);
        this.business = new Business(proxiedFakeValueService);
        this.chuckNorris = new ChuckNorris(proxiedFakeValueService);
        this.color = new Color(proxiedFakeValueService);
        this.idNumber = new IdNumber(this, proxiedFakeValueService);
        this.hacker = new Hacker(proxiedFakeValueService);
        this.company = new Company(this, proxiedFakeValueService, this.randomService);
        this.crypto = new Crypto(this.lorem);
        this.commerce = new Commerce(proxiedFakeValueService, this.randomService);
        this.options = new Options(this.randomService);
        this.code = new Code(this.randomService);
        this.finance = new Finance(proxiedFakeValueService, this.randomService);
        this.dateAndTime = new DateAndTime(this.randomService);
        this.educator = new Educator(proxiedFakeValueService);
        this.shakespeare = new Shakespeare(this.randomService);
        this.superhero = new Superhero(this, proxiedFakeValueService);
        this.team = new Team(this, proxiedFakeValueService);
        this.bool = new Bool(this.randomService);
        this.beer = new Beer(proxiedFakeValueService);
        this.university = new University(this, proxiedFakeValueService);
    }

    private static FakeValuesServiceInterface createProxiedFakeValuesService(FakeValuesServiceInterface fakeValuesServiceInterface, FakeValuesServiceInterface defaultFakeValuesServiceInterface) {
        return (FakeValuesServiceInterface)Proxy.newProxyInstance(Faker.class.getClassLoader(), new Class[]{FakeValuesServiceInterface.class}, (InvocationHandler)new DefaultingFakeValuesService(fakeValuesServiceInterface, defaultFakeValuesServiceInterface));
    }

    public String numerify(String numberString) {
        return this.fakeValuesService.numerify(numberString);
    }

    public String letterify(String letterString) {
        return this.fakeValuesService.letterify(letterString);
    }

    public String bothify(String string) {
        return this.fakeValuesService.bothify(string);
    }

    public String regexify(String regex) {
        return this.fakeValuesService.regexify(regex);
    }

    public App app() {
        return this.app;
    }

    public Name name() {
        return this.name;
    }

    public Number number() {
        return this.number;
    }

    public Internet internet() {
        return this.internet;
    }

    public PhoneNumber phoneNumber() {
        return this.phoneNumber;
    }

    public Lorem lorem() {
        return this.lorem;
    }

    public Address address() {
        return this.address;
    }

    public Book book() {
        return this.book;
    }

    public Business business() {
        return this.business;
    }

    public ChuckNorris chuckNorris() {
        return this.chuckNorris;
    }

    public Color color() {
        return this.color;
    }

    public Commerce commerce() {
        return this.commerce;
    }

    public Company company() {
        return this.company;
    }

    public Crypto crypto() {
        return this.crypto;
    }

    public Hacker hacker() {
        return this.hacker;
    }

    public IdNumber idNumber() {
        return this.idNumber;
    }

    public Options options() {
        return this.options;
    }

    public Code code() {
        return this.code;
    }

    public Finance finance() {
        return this.finance;
    }

    public DateAndTime date() {
        return this.dateAndTime;
    }

    public Educator educator() {
        return this.educator;
    }

    public Shakespeare shakespeare() {
        return this.shakespeare;
    }

    public Superhero superhero() {
        return this.superhero;
    }

    public Bool bool() {
        return this.bool;
    }

    public Team team() {
        return this.team;
    }

    public Beer beer() {
        return this.beer;
    }

    public University university() {
        return this.university;
    }

    @Override
    public String resolve(String key) {
        String[] keySplit = key.split("\\.", 2);
        String object = WordUtils.uncapitalize((String)keySplit[0]);
        String methodName = keySplit[1];
        char[] METHOD_NAME_REPLACEMENT = new char[]{'_'};
        methodName = WordUtils.capitalizeFully((String)methodName, (char[])METHOD_NAME_REPLACEMENT).replaceAll("_", "");
        methodName = methodName.substring(0, 1).toLowerCase() + methodName.substring(1);
        try {
            Object objectWithMethodToInvoke = MethodUtils.invokeMethod((Object)this, (String)object, null);
            return (String)MethodUtils.invokeMethod((Object)objectWithMethodToInvoke, (String)methodName, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

