/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.service.FakeValuesServiceInterface;
import com.github.javafaker.service.RandomService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Lorem {
    private static final char[] characters;
    private final FakeValuesServiceInterface fakeValuesService;
    private final RandomService randomService;

    public Lorem(FakeValuesServiceInterface fakeValuesService, RandomService randomService) {
        this.fakeValuesService = fakeValuesService;
        this.randomService = randomService;
    }

    public char character() {
        return this.character(false);
    }

    public char character(boolean includeUppercase) {
        return this.characters(1).charAt(0);
    }

    public String characters() {
        return this.characters(255, false);
    }

    public String characters(boolean includeUppercase) {
        return this.characters(255, false);
    }

    public String characters(int minimumLength, int maximumLength) {
        return this.characters(this.randomService.nextInt(maximumLength - minimumLength) + minimumLength, false);
    }

    public String characters(int minimumLength, int maximumLength, boolean includeUppercase) {
        return this.characters(this.randomService.nextInt(maximumLength - minimumLength) + minimumLength, includeUppercase);
    }

    public String characters(int fixedNumberOfCharacters) {
        return this.characters(fixedNumberOfCharacters, false);
    }

    public String characters(int fixedNumberOfCharacters, boolean includeUppercase) {
        if (fixedNumberOfCharacters < 1) {
            return "";
        }
        char[] buffer = new char[fixedNumberOfCharacters];
        for (int i = 0; i < buffer.length; ++i) {
            char randomCharacter = characters[this.randomService.nextInt(characters.length)];
            if (includeUppercase && this.randomService.nextBoolean().booleanValue()) {
                randomCharacter = Character.toUpperCase(randomCharacter);
            }
            buffer[i] = randomCharacter;
        }
        return new String(buffer);
    }

    public List<String> words(int num) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            returnList.add(this.word());
        }
        return returnList;
    }

    public List<String> words() {
        return this.words(3);
    }

    public String word() {
        return this.fakeValuesService.safeFetch("lorem.words");
    }

    public String sentence(int wordCount) {
        return StringUtils.capitalize((String)(StringUtils.join(this.words(wordCount + this.randomService.nextInt(6)), (String)" ") + "."));
    }

    public String sentence() {
        return this.sentence(3);
    }

    public List<String> sentences(int sentenceCount) {
        ArrayList<String> sentences = new ArrayList<String>(sentenceCount);
        for (int i = 0; i < sentenceCount; ++i) {
            sentences.add(this.sentence());
        }
        return sentences;
    }

    public String paragraph(int sentenceCount) {
        return StringUtils.join(this.sentences(sentenceCount + this.randomService.nextInt(3)), (String)" ");
    }

    public String paragraph() {
        return this.paragraph(3);
    }

    public List<String> paragraphs(int paragraphCount) {
        ArrayList<String> paragraphs = new ArrayList<String>(paragraphCount);
        for (int i = 0; i < paragraphCount; ++i) {
            paragraphs.add(this.paragraph());
        }
        return paragraphs;
    }

    public String fixedString(int numberOfLetters) {
        StringBuilder builder = new StringBuilder();
        while (builder.length() < numberOfLetters) {
            builder.append(this.sentence());
        }
        return StringUtils.substring((String)builder.toString(), (int)0, (int)numberOfLetters);
    }

    static {
        StringBuilder builder = new StringBuilder(36);
        for (char number = '0'; number <= '9'; number = (char)(number + '\u0001')) {
            builder.append(number);
        }
        for (char character = 'a'; character <= 'z'; character = (char)(character + '\u0001')) {
            builder.append(character);
        }
        characters = builder.toString().toCharArray();
    }
}

