/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker.service;

import java.util.Random;
import org.apache.commons.lang.math.RandomUtils;

public class RandomService {
    private final Random random;

    public RandomService(Random random) {
        this.random = random != null ? random : RandomUtils.JVM_RANDOM;
    }

    public int nextInt(int n) {
        return RandomUtils.nextInt((Random)this.random, (int)n);
    }

    public long nextLong() {
        return RandomUtils.nextLong((Random)this.random);
    }

    public long nextLong(long n) {
        long val;
        long randomLong;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        while ((bits = (randomLong = RandomUtils.nextLong((Random)this.random)) << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public double nextDouble() {
        return RandomUtils.nextDouble((Random)this.random);
    }

    public Boolean nextBoolean() {
        return RandomUtils.nextBoolean((Random)this.random);
    }
}

