/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.nonblocking.iobalancer;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.tcp.nonblocking.MigratableHandler;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.nio.tcp.nonblocking.iobalancer.LoadImbalance;
import com.hazelcast.util.ItemCounter;
import com.hazelcast.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

class LoadTracker {
    private final ILogger logger;
    private final NonBlockingIOThread[] ioThreads;
    private final Map<NonBlockingIOThread, Set<MigratableHandler>> selectorToHandlers;
    private final ItemCounter<MigratableHandler> lastEventCounter = new ItemCounter();
    private final ItemCounter<NonBlockingIOThread> selectorEvents = new ItemCounter();
    private final ItemCounter<MigratableHandler> handlerEventsCounter = new ItemCounter();
    private final Set<MigratableHandler> handlers = new HashSet<MigratableHandler>();
    private final LoadImbalance imbalance;
    private final Queue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();

    LoadTracker(NonBlockingIOThread[] ioThreads, ILogger logger) {
        this.logger = logger;
        this.ioThreads = new NonBlockingIOThread[ioThreads.length];
        System.arraycopy(ioThreads, 0, this.ioThreads, 0, ioThreads.length);
        this.selectorToHandlers = new HashMap<NonBlockingIOThread, Set<MigratableHandler>>();
        for (NonBlockingIOThread selector : ioThreads) {
            this.selectorToHandlers.put(selector, new HashSet());
        }
        this.imbalance = new LoadImbalance(this.selectorToHandlers, this.handlerEventsCounter);
    }

    LoadImbalance updateImbalance() {
        this.handleAddedOrRemovedConnections();
        this.clearWorkingImbalance();
        this.updateNewWorkingImbalance();
        this.updateNewFinalImbalance();
        this.printDebugTable();
        return this.imbalance;
    }

    private void handleAddedOrRemovedConnections() {
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            Runnable task = (Runnable)iterator.next();
            task.run();
            iterator.remove();
        }
    }

    Set<MigratableHandler> getHandlers() {
        return this.handlers;
    }

    ItemCounter<MigratableHandler> getLastEventCounter() {
        return this.lastEventCounter;
    }

    ItemCounter<MigratableHandler> getHandlerEventsCounter() {
        return this.handlerEventsCounter;
    }

    private void updateNewFinalImbalance() {
        this.imbalance.minimumEvents = Long.MAX_VALUE;
        this.imbalance.maximumEvents = Long.MIN_VALUE;
        this.imbalance.sourceSelector = null;
        this.imbalance.destinationSelector = null;
        for (NonBlockingIOThread selector : this.ioThreads) {
            long eventCount = this.selectorEvents.get(selector);
            int handlerCount = this.selectorToHandlers.get(selector).size();
            if (eventCount > this.imbalance.maximumEvents && handlerCount > 1) {
                this.imbalance.maximumEvents = eventCount;
                this.imbalance.sourceSelector = selector;
            }
            if (eventCount >= this.imbalance.minimumEvents) continue;
            this.imbalance.minimumEvents = eventCount;
            this.imbalance.destinationSelector = selector;
        }
    }

    public void notifyHandlerAdded(MigratableHandler handler) {
        AddHandlerTask addHandlerTask = new AddHandlerTask(handler);
        this.tasks.offer(addHandlerTask);
    }

    public void notifyHandlerRemoved(MigratableHandler handler) {
        RemoveHandlerTask removeHandlerTask = new RemoveHandlerTask(handler);
        this.tasks.offer(removeHandlerTask);
    }

    private void updateNewWorkingImbalance() {
        for (MigratableHandler handler : this.handlers) {
            this.updateHandlerState(handler);
        }
    }

    private void updateHandlerState(MigratableHandler handler) {
        long handlerEventCount = this.getEventCountSinceLastCheck(handler);
        this.handlerEventsCounter.set(handler, handlerEventCount);
        NonBlockingIOThread owner = handler.getOwner();
        this.selectorEvents.add(owner, handlerEventCount);
        Set<MigratableHandler> handlersOwnedBy = this.selectorToHandlers.get(owner);
        handlersOwnedBy.add(handler);
    }

    private long getEventCountSinceLastCheck(MigratableHandler handler) {
        long eventCount = handler.getEventCount();
        Long lastEventCount = this.lastEventCounter.getAndSet(handler, eventCount);
        return eventCount - lastEventCount;
    }

    private void clearWorkingImbalance() {
        this.handlerEventsCounter.reset();
        this.selectorEvents.reset();
        for (Set<MigratableHandler> handlerSet : this.selectorToHandlers.values()) {
            handlerSet.clear();
        }
    }

    void addHandler(MigratableHandler handler) {
        this.handlers.add(handler);
    }

    void removeHandler(MigratableHandler handler) {
        this.handlers.remove(handler);
        this.handlerEventsCounter.remove(handler);
        this.lastEventCounter.remove(handler);
    }

    private void printDebugTable() {
        if (!this.logger.isFinestEnabled()) {
            return;
        }
        NonBlockingIOThread minThread = this.imbalance.destinationSelector;
        NonBlockingIOThread maxThread = this.imbalance.sourceSelector;
        if (minThread == null || maxThread == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(StringUtil.LINE_SEPARATOR).append("------------").append(StringUtil.LINE_SEPARATOR);
        Long eventCountPerSelector = this.selectorEvents.get(minThread);
        sb.append("Min Selector ").append(minThread).append(" received ").append(eventCountPerSelector).append(" events. ");
        sb.append("It contains following handlers: ").append(StringUtil.LINE_SEPARATOR);
        this.appendSelectorInfo(minThread, this.selectorToHandlers, sb);
        eventCountPerSelector = this.selectorEvents.get(maxThread);
        sb.append("Max Selector ").append(maxThread).append(" received ").append(eventCountPerSelector).append(" events. ");
        sb.append("It contains following handlers: ").append(StringUtil.LINE_SEPARATOR);
        this.appendSelectorInfo(maxThread, this.selectorToHandlers, sb);
        sb.append("Other Selectors: ").append(StringUtil.LINE_SEPARATOR);
        for (NonBlockingIOThread selector : this.ioThreads) {
            if (selector.equals(minThread) || selector.equals(maxThread)) continue;
            eventCountPerSelector = this.selectorEvents.get(selector);
            sb.append("Selector ").append(selector).append(" contains ").append(eventCountPerSelector).append(" and has these handlers: ").append(StringUtil.LINE_SEPARATOR);
            this.appendSelectorInfo(selector, this.selectorToHandlers, sb);
        }
        sb.append("------------").append(StringUtil.LINE_SEPARATOR);
        this.logger.finest(sb.toString());
    }

    private void appendSelectorInfo(NonBlockingIOThread minThread, Map<NonBlockingIOThread, Set<MigratableHandler>> threadHandlers, StringBuilder sb) {
        Set<MigratableHandler> handlerSet = threadHandlers.get(minThread);
        for (MigratableHandler selectionHandler : handlerSet) {
            Long eventCountPerHandler = this.handlerEventsCounter.get(selectionHandler);
            sb.append(selectionHandler).append(":  ").append(eventCountPerHandler).append(StringUtil.LINE_SEPARATOR);
        }
        sb.append(StringUtil.LINE_SEPARATOR);
    }

    class AddHandlerTask
    implements Runnable {
        private final MigratableHandler handler;

        public AddHandlerTask(MigratableHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            if (LoadTracker.this.logger.isFinestEnabled()) {
                LoadTracker.this.logger.finest("Adding handler : " + this.handler);
            }
            LoadTracker.this.addHandler(this.handler);
        }
    }

    class RemoveHandlerTask
    implements Runnable {
        private final MigratableHandler handler;

        public RemoveHandlerTask(MigratableHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            if (LoadTracker.this.logger.isFinestEnabled()) {
                LoadTracker.this.logger.finest("Removing handler : " + this.handler);
            }
            LoadTracker.this.removeHandler(this.handler);
        }
    }
}

