/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.redis;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.redis.RedisPersistence;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import redis.clients.jedis.Pipeline;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001b\t1\")\u001b8bef\u0014V\rZ5t!\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0004\t\u0005)!/\u001a3jg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\r)b\u0003G\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0011%\u0016$\u0017n\u001d)feNL7\u000f^3oG\u0016\u00042aD\r\u001c\u0013\tQ\u0002CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u00109%\u0011Q\u0004\u0005\u0002\u0005\u0005f$X\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011Q\u0003\u0001\u0005\u0006G\u0001!\t\u0005J\u0001\u0005g\u00064X\rF\u0003&QMbd\b\u0005\u0002\u0010M%\u0011q\u0005\u0005\u0002\u0005+:LG\u000fC\u0003*E\u0001\u0007!&\u0001\u0005qSB,G.\u001b8f!\tY\u0013'D\u0001-\u0015\tic&A\u0003kK\u0012L7O\u0003\u00020a\u000591\r\\5f]R\u001c(\"A\u0002\n\u0005Ib#\u0001\u0003)ja\u0016d\u0017N\\3\t\u000bQ\u0012\u0003\u0019A\u001b\u0002\u0007-,\u0017\u0010\u0005\u00027s9\u0011qbN\u0005\u0003qA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001\b\u0005\u0005\u0006{\t\u0002\r\u0001G\u0001\u0006m\u0006dW/\u001a\u0005\u0006\u007f\t\u0002\r\u0001Q\u0001\u0004iRd\u0007CA\bB\u0013\t\u0011\u0005CA\u0002J]RDQ\u0001\u0012\u0001\u0005B\u0015\u000bA\u0001\\8bIR!QER$I\u0011\u0015I3\t1\u0001+\u0011\u0015!4\t1\u00016\u0011\u0015I5\t1\u0001K\u0003=\u0011X-];je\u0016$7i\u001c7v[:\u001c\bcA&Tk9\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f2\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005I\u0003\u0012a\u00029bG.\fw-Z\u0005\u0003)V\u00131aU3r\u0015\t\u0011\u0006\u0003C\u0003X\u0001\u0011\u0005\u0003,A\u0005f]\u000e|G-\u001a*poR\u0011\u0001$\u0017\u0005\u0006{Y\u0003\rA\u0017\t\u00037rk\u0011\u0001B\u0005\u0003;\u0012\u00111AU8x\u0011\u0015y\u0006\u0001\"\u0011a\u0003%!WmY8eKJ{w\u000f\u0006\u0003[C\nl\u0007\"B\u001f_\u0001\u0004A\u0002BB2_\t\u0003\u0007A-\u0001\u0004tG\",W.\u0019\t\u0004\u001f\u0015<\u0017B\u00014\u0011\u0005!a$-\u001f8b[\u0016t\u0004C\u00015l\u001b\u0005I'B\u00016\u0005\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0017N\u0001\u0006TiJ,8\r\u001e+za\u0016DQA\u001c0A\u0002=\f1\"\u001b8gKJ\u001c6\r[3nCB\u0011q\u0002]\u0005\u0003cB\u0011qAQ8pY\u0016\fg\u000e")
public class BinaryRedisPersistence
implements RedisPersistence<byte[]> {
    @Override
    public void save(Pipeline pipeline, String key, byte[] value, int ttl) {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        if (ttl > 0) {
            pipeline.setex(keyBytes, ttl, value);
        } else {
            pipeline.set(keyBytes, value);
        }
    }

    @Override
    public void load(Pipeline pipeline, String key, Seq<String> requiredColumns) {
        pipeline.get(key.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] encodeRow(Row value) {
        String[] fields = (String[])Predef$.MODULE$.refArrayOps((Object[])value.schema().fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$1) {
                return x$1.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Object[] valuesArray = (Object[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(this, value){
            public static final long serialVersionUID = 0L;
            private final Row value$1;

            public final Object apply(String f) {
                return this.value$1.getAs(f);
            }
            {
                this.value$1 = value$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        return SerializationUtils.serialize((java.io.Serializable)((java.io.Serializable)valuesArray));
    }

    @Override
    public Row decodeRow(byte[] value, Function0<StructType> schema2, boolean inferSchema2) {
        Object[] valuesArray = (Object[])SerializationUtils.deserialize((byte[])value);
        return new GenericRowWithSchema(valuesArray, (StructType)schema2.apply());
    }
}

