/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input;

import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.CharInputReader;
import java.util.Arrays;

public class DefaultCharAppender
implements CharAppender {
    final char[] emptyChars;
    char[] chars;
    int index = 0;
    final String emptyValue;
    int whitespaceCount = 0;

    public DefaultCharAppender(int maxLength, String emptyValue) {
        this.chars = new char[maxLength];
        this.emptyValue = emptyValue;
        this.emptyChars = (char[])(emptyValue == null ? null : emptyValue.toCharArray());
    }

    @Override
    public void appendIgnoringPadding(char ch, char padding) {
        this.chars[this.index++] = ch;
        this.whitespaceCount = ch == padding ? ++this.whitespaceCount : 0;
    }

    @Override
    public void appendIgnoringWhitespaceAndPadding(char ch, char padding) {
        this.chars[this.index++] = ch;
        this.whitespaceCount = ch <= ' ' || ch == padding ? ++this.whitespaceCount : 0;
    }

    @Override
    public void appendIgnoringWhitespace(char ch) {
        this.chars[this.index++] = ch;
        this.whitespaceCount = ch <= ' ' ? ++this.whitespaceCount : 0;
    }

    @Override
    public void append(char ch) {
        this.chars[this.index++] = ch;
    }

    @Override
    public final String getAndReset() {
        String out = this.emptyValue;
        if (this.index > this.whitespaceCount) {
            out = new String(this.chars, 0, this.index - this.whitespaceCount);
        }
        this.index = 0;
        this.whitespaceCount = 0;
        return out;
    }

    @Override
    public final String toString() {
        if (this.index <= this.whitespaceCount) {
            return this.emptyValue;
        }
        return new String(this.chars, 0, this.index - this.whitespaceCount);
    }

    @Override
    public final int length() {
        return this.index - this.whitespaceCount;
    }

    @Override
    public final char[] getCharsAndReset() {
        char[] out = this.emptyChars;
        if (this.index > this.whitespaceCount) {
            out = Arrays.copyOf(this.chars, this.index - this.whitespaceCount);
        }
        this.index = 0;
        this.whitespaceCount = 0;
        return out;
    }

    @Override
    public final int whitespaceCount() {
        return this.whitespaceCount;
    }

    @Override
    public final void reset() {
        this.index = 0;
        this.whitespaceCount = 0;
    }

    public void append(DefaultCharAppender appender) {
        System.arraycopy(appender.chars, 0, this.chars, this.index, appender.index - appender.whitespaceCount);
        this.index += appender.index - appender.whitespaceCount;
        appender.reset();
    }

    @Override
    public final void resetWhitespaceCount() {
        this.whitespaceCount = 0;
    }

    @Override
    public final char[] getChars() {
        return this.chars;
    }

    @Override
    public void fill(char ch, int length) {
        for (int i = 0; i < length; ++i) {
            this.chars[this.index++] = ch;
        }
    }

    @Override
    public void prepend(char ch) {
        System.arraycopy(this.chars, 0, this.chars, 1, this.index);
        this.chars[0] = ch;
        ++this.index;
    }

    @Override
    public void prepend(char ch1, char ch2) {
        System.arraycopy(this.chars, 0, this.chars, 2, this.index);
        this.chars[0] = ch1;
        this.chars[1] = ch2;
        this.index += 2;
    }

    @Override
    public final void updateWhitespace() {
        this.whitespaceCount = 0;
        int i = this.index - 1;
        while (i >= 0 && this.chars[i] <= ' ') {
            --i;
            ++this.whitespaceCount;
        }
    }

    @Override
    public char appendUntil(char ch, CharInputReader input, char stop) {
        while (ch != stop) {
            this.chars[this.index++] = ch;
            ch = input.nextChar();
        }
        return ch;
    }

    @Override
    public char appendUntil(char ch, CharInputReader input, char stop1, char stop2) {
        while (ch != stop1 && ch != stop2) {
            this.chars[this.index++] = ch;
            ch = input.nextChar();
        }
        return ch;
    }

    @Override
    public char appendUntil(char ch, CharInputReader input, char stop1, char stop2, char stop3) {
        while (ch != stop1 && ch != stop2 && ch != stop3) {
            this.chars[this.index++] = ch;
            ch = input.nextChar();
        }
        return ch;
    }

    @Override
    public void append(char[] ch, int from, int length) {
        System.arraycopy(ch, from, this.chars, this.index, length);
        this.index += length;
    }

    @Override
    public final void append(char[] ch) {
        this.append(ch, 0, ch.length);
    }

    @Override
    public void append(String string, int from, int to) {
        string.getChars(from, to, this.chars, this.index);
        this.index += to - from;
    }

    @Override
    public final void append(String string) {
        this.append(string, 0, string.length());
    }

    @Override
    public final char charAt(int i) {
        return this.chars[i];
    }

    @Override
    public final String subSequence(int from, int to) {
        return new String(this.chars, from, to - from);
    }
}

