/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.gradle.nexus;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovyx.net.http.RESTClient;
import io.codearte.gradle.nexus.infra.SimplifiedHttpJsonRestClient;
import io.codearte.gradle.nexus.logic.OperationRetrier;
import io.codearte.gradle.nexus.logic.RepositoryCloser;
import io.codearte.gradle.nexus.logic.RepositoryFetcher;
import io.codearte.gradle.nexus.logic.RepositoryReleaser;
import io.codearte.gradle.nexus.logic.RepositoryStateFetcher;
import io.codearte.gradle.nexus.logic.StagingProfileFetcher;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public abstract class BaseStagingTask
extends DefaultTask
implements GroovyObject {
    @Input
    private String serverUrl;
    @Input
    @Optional
    private String username;
    @Input
    @Optional
    private String password;
    @Input
    private String packageGroup;
    @Input
    @Optional
    private String stagingProfileId;
    @Input
    @Optional
    private Integer numberOfRetries;
    @Input
    @Optional
    private Integer delayBetweenRetriesInMillis;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public BaseStagingTask() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    SimplifiedHttpJsonRestClient createClient() {
        return new SimplifiedHttpJsonRestClient(new RESTClient(), this.getUsername(), this.getPassword());
    }

    protected StagingProfileFetcher createFetcherWithGivenClient(SimplifiedHttpJsonRestClient client) {
        return new StagingProfileFetcher(client, this.getServerUrl());
    }

    protected RepositoryFetcher createRepositoryFetcherWithGivenClient(SimplifiedHttpJsonRestClient client) {
        return new RepositoryFetcher(client, this.getServerUrl());
    }

    protected RepositoryStateFetcher createRepositoryStateFetcherWithGivenClient(SimplifiedHttpJsonRestClient client) {
        return new RepositoryStateFetcher(client, this.getServerUrl());
    }

    protected RepositoryCloser createRepositoryCloserWithGivenClient(SimplifiedHttpJsonRestClient client) {
        return new RepositoryCloser(client, this.getServerUrl());
    }

    protected RepositoryReleaser createRepositoryReleaserWithGivenClient(SimplifiedHttpJsonRestClient client) {
        return new RepositoryReleaser(client, this.getServerUrl());
    }

    protected <T> OperationRetrier<T> createOperationRetrier() {
        return new OperationRetrier(this.getNumberOfRetries(), this.getDelayBetweenRetriesInMillis());
    }

    protected String fetchAndCacheStagingProfileId(StagingProfileFetcher stagingProfileFetcher) {
        String configuredStagingProfileId = this.getStagingProfileId();
        if (configuredStagingProfileId != null) {
            this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{configuredStagingProfileId}, new String[]{"Using configured staging profile id: ", ""})));
            return configuredStagingProfileId;
        }
        String receivedStagingProfileId = stagingProfileFetcher.getStagingProfileIdForPackageGroup(this.getPackageGroup());
        this.setStagingProfileId(receivedStagingProfileId);
        return receivedStagingProfileId;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != BaseStagingTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String string) {
        this.serverUrl = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPackageGroup() {
        return this.packageGroup;
    }

    public void setPackageGroup(String string) {
        this.packageGroup = string;
    }

    public String getStagingProfileId() {
        return this.stagingProfileId;
    }

    public void setStagingProfileId(String string) {
        this.stagingProfileId = string;
    }

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(Integer n) {
        this.numberOfRetries = n;
    }

    public Integer getDelayBetweenRetriesInMillis() {
        return this.delayBetweenRetriesInMillis;
    }

    public void setDelayBetweenRetriesInMillis(Integer n) {
        this.delayBetweenRetriesInMillis = n;
    }
}

