/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.propagation.B3SingleFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.nio.charset.Charset;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;

final class KafkaPropagation {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final TraceContext TEST_CONTEXT = TraceContext.newBuilder().traceId(1L).spanId(1L).build();
    static final Headers B3_SINGLE_TEST_HEADERS = new RecordHeaders().add("b3", B3SingleFormat.writeB3SingleFormat((TraceContext)TEST_CONTEXT).getBytes(UTF_8));
    static final TraceContext.Injector<Headers> B3_SINGLE_INJECTOR = new TraceContext.Injector<Headers>(){

        public void inject(TraceContext traceContext, Headers carrier) {
            carrier.add("b3", B3SingleFormat.writeB3SingleFormatWithoutParentIdAsBytes((TraceContext)traceContext));
        }

        public String toString() {
            return "Headers::add(\"b3\",singleHeaderFormatWithoutParent)";
        }
    };
    static final Propagation.Setter<Headers, String> SETTER = (carrier, key, value) -> {
        carrier.remove(key);
        carrier.add(key, value.getBytes(UTF_8));
    };
    static final Propagation.Getter<Headers, String> GETTER = (carrier, key) -> {
        Header header = carrier.lastHeader(key);
        if (header == null) {
            return null;
        }
        return new String(header.value(), UTF_8);
    };

    KafkaPropagation() {
    }
}

