/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.compilerutils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public class TypeMirrorUtils {
    private Types typeUtils;
    private Elements elementUtils;

    public TypeMirrorUtils(Types typeUtils, Elements elementUtils) {
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
    }

    public final Collection<TypeMirror> procedureAllowedTypes() {
        PrimitiveType bool = this.primitive(TypeKind.BOOLEAN);
        PrimitiveType longType = this.primitive(TypeKind.LONG);
        PrimitiveType doubleType = this.primitive(TypeKind.DOUBLE);
        return Arrays.asList(bool, this.boxed(bool), longType, this.boxed(longType), doubleType, this.boxed(doubleType), this.typeMirror(String.class), this.typeMirror(Number.class), this.typeMirror(Object.class), this.typeMirror(Map.class), this.typeMirror(List.class), this.typeMirror(Node.class), this.typeMirror(Relationship.class), this.typeMirror(Path.class));
    }

    public PrimitiveType primitive(TypeKind kind) {
        return this.typeUtils.getPrimitiveType(kind);
    }

    public TypeMirror typeMirror(Class<?> type) {
        return this.elementUtils.getTypeElement(type.getName()).asType();
    }

    private TypeMirror boxed(PrimitiveType bool) {
        return this.typeUtils.boxedClass(bool).asType();
    }
}

