// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.9.1,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.doxia.document.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.apache.maven.doxia.document.DocumentAuthor;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentHyperlinkBehaviour;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentStatistic;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.DocumentTemplate;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/**
 * Class DocumentXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class DocumentXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;

    /**
     * Field contentTransformer.
     */
    public final ContentTransformer contentTransformer;


      //----------------/
     //- Constructors -/
    //----------------/

    public DocumentXpp3Reader()
    {
        this( new ContentTransformer()
        {
            public String transform( String source, String fieldName )
            {
                return source;
            }
        } );
    } //-- org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Reader()

    public DocumentXpp3Reader(ContentTransformer contentTransformer)
    {
        this.contentTransformer = contentTransformer;
    } //-- org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Reader(ContentTransformer)


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser
     * @param parsed
     * @param alias
     * @param tagName
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser
     * @param strict
     * @param tagName
     * @param attribute
     * @throws XmlPullParserException
     * @throws IOException
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser
     * @param strict
     * @throws XmlPullParserException
     * @throws IOException
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param defaultValue
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param parser
     * @param dateFormat
     * @param attribute
     * @throws XmlPullParserException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method interpolatedTrimmed.
     * 
     * @param value
     * @param context
     * @return String
     */
    private String interpolatedTrimmed( String value, String context )
    {
        return getTrimmedValue( contentTransformer.transform( value, context ) );
    } //-- String interpolatedTrimmed( String, String )

    /**
     * Method nextTag.
     * 
     * @param parser
     * @throws IOException
     * @throws XmlPullParserException
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentModel
     */
    public DocumentModel read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- DocumentModel read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentModel
     */
    public DocumentModel read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- DocumentModel read( Reader )

    /**
     * Method read.
     * 
     * @param in
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentModel
     */
    public DocumentModel read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- DocumentModel read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentModel
     */
    public DocumentModel read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- DocumentModel read( InputStream )

    /**
     * Method parseDocumentAuthor.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentAuthor
     */
    private DocumentAuthor parseDocumentAuthor( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocumentAuthor documentAuthor = new DocumentAuthor();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "firstName", null, parsed ) )
            {
                documentAuthor.setFirstName( interpolatedTrimmed( parser.nextText(), "firstName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "lastName", null, parsed ) )
            {
                documentAuthor.setLastName( interpolatedTrimmed( parser.nextText(), "lastName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "name", null, parsed ) )
            {
                documentAuthor.setName( interpolatedTrimmed( parser.nextText(), "name" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "initials", null, parsed ) )
            {
                documentAuthor.setInitials( interpolatedTrimmed( parser.nextText(), "initials" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "title", null, parsed ) )
            {
                documentAuthor.setTitle( interpolatedTrimmed( parser.nextText(), "title" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "position", null, parsed ) )
            {
                documentAuthor.setPosition( interpolatedTrimmed( parser.nextText(), "position" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "email", null, parsed ) )
            {
                documentAuthor.setEmail( interpolatedTrimmed( parser.nextText(), "email" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "phoneNumber", null, parsed ) )
            {
                documentAuthor.setPhoneNumber( interpolatedTrimmed( parser.nextText(), "phoneNumber" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "faxNumber", null, parsed ) )
            {
                documentAuthor.setFaxNumber( interpolatedTrimmed( parser.nextText(), "faxNumber" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "companyName", null, parsed ) )
            {
                documentAuthor.setCompanyName( interpolatedTrimmed( parser.nextText(), "companyName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "street", null, parsed ) )
            {
                documentAuthor.setStreet( interpolatedTrimmed( parser.nextText(), "street" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "city", null, parsed ) )
            {
                documentAuthor.setCity( interpolatedTrimmed( parser.nextText(), "city" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "postalCode", null, parsed ) )
            {
                documentAuthor.setPostalCode( interpolatedTrimmed( parser.nextText(), "postalCode" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "country", null, parsed ) )
            {
                documentAuthor.setCountry( interpolatedTrimmed( parser.nextText(), "country" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "state", null, parsed ) )
            {
                documentAuthor.setState( interpolatedTrimmed( parser.nextText(), "state" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return documentAuthor;
    } //-- DocumentAuthor parseDocumentAuthor( XmlPullParser, boolean )

    /**
     * Method parseDocumentCover.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentCover
     */
    private DocumentCover parseDocumentCover( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocumentCover documentCover = new DocumentCover();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "coverTitle", null, parsed ) )
            {
                documentCover.setCoverTitle( interpolatedTrimmed( parser.nextText(), "coverTitle" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "coverSubTitle", null, parsed ) )
            {
                documentCover.setCoverSubTitle( interpolatedTrimmed( parser.nextText(), "coverSubTitle" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "coverVersion", null, parsed ) )
            {
                documentCover.setCoverVersion( interpolatedTrimmed( parser.nextText(), "coverVersion" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "coverType", null, parsed ) )
            {
                documentCover.setCoverType( interpolatedTrimmed( parser.nextText(), "coverType" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "coverDate", null, parsed ) )
            {
                String dateFormat = null;
                documentCover.setCoverDate( getDateValue( interpolatedTrimmed( parser.nextText(), "coverDate" ), "coverDate", dateFormat, parser ) );
            }
            else if ( checkFieldWithDuplicate( parser, "coverdate", null, parsed ) )
            {
                documentCover.setCoverdate( interpolatedTrimmed( parser.nextText(), "coverdate" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "authors", null, parsed ) )
            {
                java.util.List<DocumentAuthor> authors = new java.util.ArrayList<DocumentAuthor>();
                documentCover.setAuthors( authors );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "author".equals( parser.getName() ) )
                    {
                        authors.add( parseDocumentAuthor( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "author", null, parsed ) )
            {
                documentCover.setAuthor( interpolatedTrimmed( parser.nextText(), "author" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "projectName", null, parsed ) )
            {
                documentCover.setProjectName( interpolatedTrimmed( parser.nextText(), "projectName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "projectLogo", null, parsed ) )
            {
                documentCover.setProjectLogo( interpolatedTrimmed( parser.nextText(), "projectLogo" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "companyName", null, parsed ) )
            {
                documentCover.setCompanyName( interpolatedTrimmed( parser.nextText(), "companyName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "companyLogo", null, parsed ) )
            {
                documentCover.setCompanyLogo( interpolatedTrimmed( parser.nextText(), "companyLogo" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return documentCover;
    } //-- DocumentCover parseDocumentCover( XmlPullParser, boolean )

    /**
     * Method parseDocumentHyperlinkBehaviour.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentHyperlinkBehaviour
     */
    private DocumentHyperlinkBehaviour parseDocumentHyperlinkBehaviour( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocumentHyperlinkBehaviour documentHyperlinkBehaviour = new DocumentHyperlinkBehaviour();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "targetFrame".equals( name ) )
            {
                documentHyperlinkBehaviour.setTargetFrame( interpolatedTrimmed( value, "targetFrame" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return documentHyperlinkBehaviour;
    } //-- DocumentHyperlinkBehaviour parseDocumentHyperlinkBehaviour( XmlPullParser, boolean )

    /**
     * Method parseDocumentMeta.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentMeta
     */
    private DocumentMeta parseDocumentMeta( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocumentMeta documentMeta = new DocumentMeta();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "title", null, parsed ) )
            {
                documentMeta.setTitle( interpolatedTrimmed( parser.nextText(), "title" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "author", null, parsed ) )
            {
                documentMeta.setAuthor( interpolatedTrimmed( parser.nextText(), "author" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "authors", null, parsed ) )
            {
                java.util.List<DocumentAuthor> authors = new java.util.ArrayList<DocumentAuthor>();
                documentMeta.setAuthors( authors );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "author".equals( parser.getName() ) )
                    {
                        authors.add( parseDocumentAuthor( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "subject", null, parsed ) )
            {
                documentMeta.setSubject( interpolatedTrimmed( parser.nextText(), "subject" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "keywords", null, parsed ) )
            {
                documentMeta.setKeywords( interpolatedTrimmed( parser.nextText(), "keywords" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "keyWords", null, parsed ) )
            {
                java.util.List<String> keyWords = new java.util.ArrayList<String>();
                documentMeta.setKeyWords( keyWords );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "keyWord".equals( parser.getName() ) )
                    {
                        keyWords.add( interpolatedTrimmed( parser.nextText(), "keyWords" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "pageSize", null, parsed ) )
            {
                documentMeta.setPageSize( interpolatedTrimmed( parser.nextText(), "pageSize" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "generator", null, parsed ) )
            {
                documentMeta.setGenerator( interpolatedTrimmed( parser.nextText(), "generator" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "description", null, parsed ) )
            {
                documentMeta.setDescription( interpolatedTrimmed( parser.nextText(), "description" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "initialCreator", null, parsed ) )
            {
                documentMeta.setInitialCreator( interpolatedTrimmed( parser.nextText(), "initialCreator" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "creator", null, parsed ) )
            {
                documentMeta.setCreator( interpolatedTrimmed( parser.nextText(), "creator" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "printedBy", null, parsed ) )
            {
                documentMeta.setPrintedBy( interpolatedTrimmed( parser.nextText(), "printedBy" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "creationDate", null, parsed ) )
            {
                String dateFormat = null;
                documentMeta.setCreationDate( getDateValue( interpolatedTrimmed( parser.nextText(), "creationDate" ), "creationDate", dateFormat, parser ) );
            }
            else if ( checkFieldWithDuplicate( parser, "creationdate", null, parsed ) )
            {
                documentMeta.setCreationdate( interpolatedTrimmed( parser.nextText(), "creationdate" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "date", null, parsed ) )
            {
                String dateFormat = null;
                documentMeta.setDate( getDateValue( interpolatedTrimmed( parser.nextText(), "date" ), "date", dateFormat, parser ) );
            }
            else if ( checkFieldWithDuplicate( parser, "modifydate", null, parsed ) )
            {
                documentMeta.setModifydate( interpolatedTrimmed( parser.nextText(), "modifydate" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "printDate", null, parsed ) )
            {
                String dateFormat = null;
                documentMeta.setPrintDate( getDateValue( interpolatedTrimmed( parser.nextText(), "printDate" ), "printDate", dateFormat, parser ) );
            }
            else if ( checkFieldWithDuplicate( parser, "printdate", null, parsed ) )
            {
                documentMeta.setPrintdate( interpolatedTrimmed( parser.nextText(), "printdate" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "template", null, parsed ) )
            {
                documentMeta.setTemplate( parseDocumentTemplate( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "hyperlinkBehaviour", null, parsed ) )
            {
                documentMeta.setHyperlinkBehaviour( parseDocumentHyperlinkBehaviour( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "language", null, parsed ) )
            {
                documentMeta.setLanguage( interpolatedTrimmed( parser.nextText(), "language" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "editingCycles", null, parsed ) )
            {
                documentMeta.setEditingCycles( getLongValue( interpolatedTrimmed( parser.nextText(), "editingCycles" ), "editingCycles", parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "editingDuration", null, parsed ) )
            {
                documentMeta.setEditingDuration( getLongValue( interpolatedTrimmed( parser.nextText(), "editingDuration" ), "editingDuration", parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "documentStatistic", null, parsed ) )
            {
                documentMeta.setDocumentStatistic( parseDocumentStatistic( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "confidential", null, parsed ) )
            {
                documentMeta.setConfidential( getBooleanValue( interpolatedTrimmed( parser.nextText(), "confidential" ), "confidential", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "draft", null, parsed ) )
            {
                documentMeta.setDraft( getBooleanValue( interpolatedTrimmed( parser.nextText(), "draft" ), "draft", parser, "false" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return documentMeta;
    } //-- DocumentMeta parseDocumentMeta( XmlPullParser, boolean )

    /**
     * Method parseDocumentModel.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentModel
     */
    private DocumentModel parseDocumentModel( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocumentModel documentModel = new DocumentModel();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else if ( "outputName".equals( name ) )
            {
                documentModel.setOutputName( interpolatedTrimmed( value, "outputName" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "meta", null, parsed ) )
            {
                documentModel.setMeta( parseDocumentMeta( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "toc", null, parsed ) )
            {
                documentModel.setToc( parseDocumentTOC( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "cover", null, parsed ) )
            {
                documentModel.setCover( parseDocumentCover( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return documentModel;
    } //-- DocumentModel parseDocumentModel( XmlPullParser, boolean )

    /**
     * Method parseDocumentStatistic.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentStatistic
     */
    private DocumentStatistic parseDocumentStatistic( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocumentStatistic documentStatistic = new DocumentStatistic();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "pageCount".equals( name ) )
            {
                documentStatistic.setPageCount( getLongValue( interpolatedTrimmed( value, "pageCount" ), "pageCount", parser, strict ) );
            }
            else if ( "tableCount".equals( name ) )
            {
                documentStatistic.setTableCount( getLongValue( interpolatedTrimmed( value, "tableCount" ), "tableCount", parser, strict ) );
            }
            else if ( "drawCount".equals( name ) )
            {
                documentStatistic.setDrawCount( getLongValue( interpolatedTrimmed( value, "drawCount" ), "drawCount", parser, strict ) );
            }
            else if ( "imageCount".equals( name ) )
            {
                documentStatistic.setImageCount( getLongValue( interpolatedTrimmed( value, "imageCount" ), "imageCount", parser, strict ) );
            }
            else if ( "objectCount".equals( name ) )
            {
                documentStatistic.setObjectCount( getLongValue( interpolatedTrimmed( value, "objectCount" ), "objectCount", parser, strict ) );
            }
            else if ( "oleObjectCount".equals( name ) )
            {
                documentStatistic.setOleObjectCount( getLongValue( interpolatedTrimmed( value, "oleObjectCount" ), "oleObjectCount", parser, strict ) );
            }
            else if ( "paragraphCount".equals( name ) )
            {
                documentStatistic.setParagraphCount( getLongValue( interpolatedTrimmed( value, "paragraphCount" ), "paragraphCount", parser, strict ) );
            }
            else if ( "wordCount".equals( name ) )
            {
                documentStatistic.setWordCount( getLongValue( interpolatedTrimmed( value, "wordCount" ), "wordCount", parser, strict ) );
            }
            else if ( "characterCount".equals( name ) )
            {
                documentStatistic.setCharacterCount( getLongValue( interpolatedTrimmed( value, "characterCount" ), "characterCount", parser, strict ) );
            }
            else if ( "rowCount".equals( name ) )
            {
                documentStatistic.setRowCount( getLongValue( interpolatedTrimmed( value, "rowCount" ), "rowCount", parser, strict ) );
            }
            else if ( "frameCount".equals( name ) )
            {
                documentStatistic.setFrameCount( getLongValue( interpolatedTrimmed( value, "frameCount" ), "frameCount", parser, strict ) );
            }
            else if ( "sentenceCount".equals( name ) )
            {
                documentStatistic.setSentenceCount( getLongValue( interpolatedTrimmed( value, "sentenceCount" ), "sentenceCount", parser, strict ) );
            }
            else if ( "syllableCount".equals( name ) )
            {
                documentStatistic.setSyllableCount( getLongValue( interpolatedTrimmed( value, "syllableCount" ), "syllableCount", parser, strict ) );
            }
            else if ( "nonWhitespaceCharacterCount".equals( name ) )
            {
                documentStatistic.setNonWhitespaceCharacterCount( getLongValue( interpolatedTrimmed( value, "nonWhitespaceCharacterCount" ), "nonWhitespaceCharacterCount", parser, strict ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return documentStatistic;
    } //-- DocumentStatistic parseDocumentStatistic( XmlPullParser, boolean )

    /**
     * Method parseDocumentTOC.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentTOC
     */
    private DocumentTOC parseDocumentTOC( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocumentTOC documentTOC = new DocumentTOC();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "name".equals( name ) )
            {
                documentTOC.setName( interpolatedTrimmed( value, "name" ) );
            }
            else if ( "depth".equals( name ) )
            {
                documentTOC.setDepth( getIntegerValue( interpolatedTrimmed( value, "depth" ), "depth", parser, strict ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( "item".equals( parser.getName() ) )
            {
                java.util.List<DocumentTOCItem> items = documentTOC.getItems();
                if ( items == null )
                {
                    items = new java.util.ArrayList<DocumentTOCItem>();
                    documentTOC.setItems( items );
                }
                items.add( parseDocumentTOCItem( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return documentTOC;
    } //-- DocumentTOC parseDocumentTOC( XmlPullParser, boolean )

    /**
     * Method parseDocumentTOCItem.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentTOCItem
     */
    private DocumentTOCItem parseDocumentTOCItem( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocumentTOCItem documentTOCItem = new DocumentTOCItem();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "name".equals( name ) )
            {
                documentTOCItem.setName( interpolatedTrimmed( value, "name" ) );
            }
            else if ( "ref".equals( name ) )
            {
                documentTOCItem.setRef( interpolatedTrimmed( value, "ref" ) );
            }
            else if ( "collapse".equals( name ) )
            {
                documentTOCItem.setCollapse( getBooleanValue( interpolatedTrimmed( value, "collapse" ), "collapse", parser, "false" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( "item".equals( parser.getName() ) )
            {
                java.util.List<DocumentTOCItem> items = documentTOCItem.getItems();
                if ( items == null )
                {
                    items = new java.util.ArrayList<DocumentTOCItem>();
                    documentTOCItem.setItems( items );
                }
                items.add( parseDocumentTOCItem( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return documentTOCItem;
    } //-- DocumentTOCItem parseDocumentTOCItem( XmlPullParser, boolean )

    /**
     * Method parseDocumentTemplate.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentTemplate
     */
    private DocumentTemplate parseDocumentTemplate( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DocumentTemplate documentTemplate = new DocumentTemplate();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "href".equals( name ) )
            {
                documentTemplate.setHref( interpolatedTrimmed( value, "href" ) );
            }
            else if ( "title".equals( name ) )
            {
                documentTemplate.setTitle( interpolatedTrimmed( value, "title" ) );
            }
            else if ( "date".equals( name ) )
            {
                String dateFormat = null;
                documentTemplate.setDate( getDateValue( interpolatedTrimmed( value, "date" ), "date", dateFormat, parser ) );
            }
            else if ( "modifydate".equals( name ) )
            {
                documentTemplate.setModifydate( interpolatedTrimmed( value, "modifydate" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return documentTemplate;
    } //-- DocumentTemplate parseDocumentTemplate( XmlPullParser, boolean )

    /**
     * Method read.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return DocumentModel
     */
    private DocumentModel read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        DocumentModel documentModel = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "document".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'document' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'document'", parser, null );
                }
                documentModel = parseDocumentModel( parser, strict );
                documentModel.setModelEncoding( parser.getInputEncoding() );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return documentModel;
        }
        throw new XmlPullParserException( "Expected root element 'document' but found no element at all: invalid XML document", parser, null );
    } //-- DocumentModel read( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

    public static interface ContentTransformer
{
    /**
     * Interpolate the value read from the xpp3 document
     * @param source The source value
     * @param fieldName A description of the field being interpolated. The implementation may use this to
     *                           log stuff.
     * @return The interpolated value.
     */
    String transform( String source, String fieldName );
}

}
