/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.vpu;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobObject;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.JacobThread;
import org.apache.ode.jacob.Synch;
import org.apache.ode.jacob.SynchChannel;
import org.apache.ode.jacob.soup.CommChannel;
import org.apache.ode.jacob.soup.CommGroup;
import org.apache.ode.jacob.soup.CommRecv;
import org.apache.ode.jacob.soup.CommSend;
import org.apache.ode.jacob.soup.Continuation;
import org.apache.ode.jacob.soup.ExecutionQueue;
import org.apache.ode.jacob.vpu.ChannelFactory;
import org.apache.ode.jacob.vpu.JacobMessages;
import org.apache.ode.jacob.vpu.Statistics;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;

public final class JacobVPU {
    private static final Log __log = LogFactory.getLog(JacobVPU.class);
    private static final JacobMessages __msgs = (JacobMessages)MessageBundle.getMessages(JacobMessages.class);
    static final ThreadLocal<Stack<JacobThread>> __activeJacobThread = new ThreadLocal();
    private static final Method REDUCE_METHOD;
    private ExecutionQueue _executionQueue;
    private Map<Class, Object> _extensions = new HashMap<Class, Object>();
    private ClassLoader _classLoader = this.getClass().getClassLoader();
    private int _cycle;
    private Statistics _statistics = new Statistics();
    private RuntimeException _fault;

    public JacobVPU() {
    }

    public JacobVPU(ExecutionQueue executionQueue) {
        this.setContext(executionQueue);
    }

    public JacobVPU(ExecutionQueue executionQueue, JacobRunnable jacobRunnable) {
        this.setContext(executionQueue);
        this.inject(jacobRunnable);
    }

    public boolean execute() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"execute", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
        if (this._executionQueue == null) {
            throw new IllegalStateException("No state object for VPU!");
        }
        if (this._fault != null) {
            throw this._fault;
        }
        if (!this._executionQueue.hasReactions()) {
            return false;
        }
        this._cycle = this._executionQueue.cycle();
        Continuation continuation = this._executionQueue.dequeueReaction();
        JacobThreadImpl jacobThreadImpl = new JacobThreadImpl(continuation);
        long l = System.currentTimeMillis();
        try {
            jacobThreadImpl.run();
        }
        catch (RuntimeException runtimeException) {
            this._fault = runtimeException;
            throw runtimeException;
        }
        long l2 = System.currentTimeMillis() - l;
        ++this._statistics.numCycles;
        this._statistics.totalRunTimeMs += l2;
        this._statistics.incRunTime(jacobThreadImpl._targetStr, l2);
        return true;
    }

    public void flush() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"flush", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
        this._executionQueue.flush();
    }

    public void setContext(ExecutionQueue executionQueue) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"setContext", (Object[])new Object[]{"executionQueue", executionQueue}));
        }
        this._executionQueue = executionQueue;
        this._executionQueue.setClassLoader(this._classLoader);
    }

    public void registerExtension(Class clazz, Object object) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"registerExtension", (Object[])new Object[]{"extensionClass", clazz, "obj", object}));
        }
        this._extensions.put(clazz, object);
    }

    public void addReaction(JacobObject jacobObject, Method method, Object[] objectArray, String string) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"addReaction", (Object[])new Object[]{"jo", jacobObject, "method", method, "args", objectArray, "desc", string}));
        }
        Continuation continuation = new Continuation(jacobObject, method, objectArray);
        continuation.setDescription(string);
        this._executionQueue.enqueueReaction(continuation);
        ++this._statistics.runQueueEntries;
    }

    public static JacobThread activeJacobThread() {
        return __activeJacobThread.get().peek();
    }

    public void inject(JacobRunnable jacobRunnable) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("injecting " + jacobRunnable));
        }
        this.addReaction(jacobRunnable, REDUCE_METHOD, CollectionUtils.EMPTY_OBJECT_ARRAY, __log.isInfoEnabled() ? jacobRunnable.toString() : null);
    }

    static String stringifyMethods(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        Method[] methodArray = clazz.getMethods();
        boolean bl = false;
        for (Method method : methodArray) {
            if (method.getDeclaringClass() == Object.class) continue;
            if (bl) {
                stringBuffer.append(" & ");
            }
            stringBuffer.append(method.getName()).append('(');
            Class<?>[] classArray = method.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(classArray[i].getName());
            }
            stringBuffer.append(") {...}");
            bl = true;
        }
        return stringBuffer.toString();
    }

    static String stringify(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
        if (this._executionQueue != null) {
            this._executionQueue.setClassLoader(classLoader);
        }
    }

    public void dumpState() {
        this._statistics.printToStream(System.err);
        this._executionQueue.dumpState(System.err);
    }

    public boolean isComplete() {
        return this._executionQueue.isComplete();
    }

    static {
        try {
            REDUCE_METHOD = JacobRunnable.class.getMethod("run", CollectionUtils.EMPTY_CLASS_ARRAY);
        }
        catch (Exception exception) {
            throw new Error("Cannot resolve 'run' method", exception);
        }
    }

    private class JacobThreadImpl
    implements Runnable,
    JacobThread {
        private final JacobObject _methodBody;
        private final Object[] _args;
        private final Method _method;
        private String _source;
        private String _targetStr = "Unknown";

        JacobThreadImpl(Continuation continuation) {
            assert (continuation != null);
            this._methodBody = continuation.getClosure();
            this._args = continuation.getArgs();
            this._source = continuation.getDescription();
            this._method = continuation.getMethod();
            if (__log.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer(this._methodBody.getClass().getName());
                stringBuffer.append('.');
                stringBuffer.append(continuation.getMethod());
                this._targetStr = stringBuffer.toString();
            }
        }

        public void instance(JacobRunnable jacobRunnable) {
            String string = null;
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": " + jacobRunnable));
                string = jacobRunnable.toString();
            }
            ++((JacobVPU)JacobVPU.this)._statistics.numReductionsStruct;
            JacobVPU.this.addReaction(jacobRunnable, REDUCE_METHOD, CollectionUtils.EMPTY_OBJECT_ARRAY, string);
        }

        public Channel message(Channel channel, Method method, Object[] objectArray) {
            Object[] objectArray2;
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": " + channel + " ! " + method.getName() + "(" + JacobVPU.stringify(objectArray) + ")"));
            }
            ++((JacobVPU)JacobVPU.this)._statistics.messagesSent;
            SynchChannel synchChannel = null;
            if (method.getReturnType() != Void.TYPE) {
                if (method.getReturnType() != SynchChannel.class) {
                    throw new IllegalStateException("ChannelListener method can only return SynchChannel: " + method);
                }
                synchChannel = (SynchChannel)this.newChannel(SynchChannel.class, "", "Reply Channel");
                objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray.length] = synchChannel;
                objectArray = objectArray2;
            }
            objectArray2 = (Object[])ChannelFactory.getBackend(channel);
            CommGroup commGroup = new CommGroup(false);
            CommSend commSend = new CommSend((CommChannel)objectArray2, method, objectArray);
            commGroup.add(commSend);
            JacobVPU.this._executionQueue.add(commGroup);
            return synchChannel;
        }

        public Channel newChannel(Class clazz, String string, String string2) {
            CommChannel commChannel = new CommChannel(clazz);
            commChannel.setDescription(string2);
            JacobVPU.this._executionQueue.add(commChannel);
            Channel channel = ChannelFactory.createChannel(commChannel, clazz);
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": new " + channel));
            }
            ++((JacobVPU)JacobVPU.this)._statistics.channelsCreated;
            return channel;
        }

        public String exportChannel(Channel channel) {
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": export<" + channel + ">"));
            }
            CommChannel commChannel = (CommChannel)ChannelFactory.getBackend(channel);
            return JacobVPU.this._executionQueue.createExport(commChannel);
        }

        public Channel importChannel(String string, Class clazz) {
            CommChannel commChannel = JacobVPU.this._executionQueue.consumeExport(string);
            return ChannelFactory.createChannel(commChannel, clazz);
        }

        public void object(boolean bl, ChannelListener[] channelListenerArray) {
            int n;
            Object object;
            if (__log.isTraceEnabled()) {
                object = new StringBuffer();
                ((StringBuffer)object).append(JacobVPU.this._cycle);
                ((StringBuffer)object).append(": ");
                for (n = 0; n < channelListenerArray.length; ++n) {
                    if (n != 0) {
                        ((StringBuffer)object).append(" + ");
                    }
                    ((StringBuffer)object).append(channelListenerArray[n].getChannel());
                    ((StringBuffer)object).append(" ? ");
                    ((StringBuffer)object).append(channelListenerArray.toString());
                }
                __log.debug((Object)((StringBuffer)object).toString());
            }
            ++((JacobVPU)JacobVPU.this)._statistics.numContinuations;
            object = new CommGroup(bl);
            for (n = 0; n < channelListenerArray.length; ++n) {
                CommChannel commChannel = (CommChannel)ChannelFactory.getBackend(channelListenerArray[n].getChannel());
                CommRecv commRecv = new CommRecv(commChannel, channelListenerArray[n]);
                ((CommGroup)object).add(commRecv);
            }
            JacobVPU.this._executionQueue.add((CommGroup)object);
        }

        public void object(boolean bl, ChannelListener channelListener) throws IllegalArgumentException {
            this.object(bl, new ChannelListener[]{channelListener});
        }

        public Object getExtension(Class clazz) {
            return JacobVPU.this._extensions.get(clazz);
        }

        public void run() {
            Synch synch;
            Object[] objectArray;
            assert (this._methodBody != null);
            assert (this._method != null);
            assert (this._method.getDeclaringClass().isAssignableFrom(this._methodBody.getClass()));
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": " + this._source));
            }
            if (this._method.getReturnType() != Void.TYPE) {
                objectArray = new Object[this._args.length - 1];
                System.arraycopy(this._args, 0, objectArray, 0, objectArray.length);
                synch = (SynchChannel)this._args[objectArray.length];
            } else {
                objectArray = this._args;
                synch = null;
            }
            this.stackThread();
            long l = System.currentTimeMillis();
            try {
                this._method.invoke((Object)this._methodBody, objectArray);
                if (synch != null) {
                    synch.ret();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                String string = __msgs.msgMethodNotAccessible(this._method.getName(), this._method.getDeclaringClass().getName());
                __log.error((Object)string, (Throwable)illegalAccessException);
                throw new RuntimeException(string, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = __msgs.msgClientMethodException(this._method.getName(), this._methodBody.getClass().getName());
                __log.error((Object)string, invocationTargetException.getTargetException());
                throw new RuntimeException(invocationTargetException.getTargetException());
            }
            finally {
                l = System.currentTimeMillis() - l;
                ((JacobVPU)JacobVPU.this)._statistics.totalClientTimeMs += l;
                this.unstackThread();
            }
        }

        public String toString() {
            return "PT[ " + this._methodBody + " ]";
        }

        private void stackThread() {
            Stack<JacobThread> stack = __activeJacobThread.get();
            if (stack == null) {
                stack = new Stack();
                __activeJacobThread.set(stack);
            }
            stack.push(this);
        }

        private JacobThread unstackThread() {
            Stack<JacobThread> stack = __activeJacobThread.get();
            assert (stack != null);
            return stack.pop();
        }
    }
}

