/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbIsolation {
    private static final Log __log = LogFactory.getLog(DbIsolation.class);
    private static int _isolationLevel;

    public static int getOdeIsolationLevel() {
        return _isolationLevel;
    }

    public static void setOdeIsolationLevel(int n) {
        _isolationLevel = n;
    }

    public static void setIsolationLevel(Connection connection) throws SQLException {
        block4: {
            try {
                if (_isolationLevel != 0 && connection.getTransactionIsolation() != _isolationLevel) {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("Set isolation level to " + _isolationLevel));
                    }
                    connection.setTransactionIsolation(_isolationLevel);
                }
            }
            catch (Exception exception) {
                if (!__log.isDebugEnabled()) break block4;
                __log.debug((Object)("Error while setting isolation level to " + _isolationLevel), (Throwable)exception);
            }
        }
    }

    static {
        try {
            _isolationLevel = Integer.parseInt(System.getProperty("ode.connection.isolation", "2"));
        }
        catch (Throwable throwable) {
            __log.error((Object)"Error while reading 'ode.connnection.isolation' property", throwable);
        }
    }
}

