/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashSet;
import org.apache.ode.utils.ProcessMutex;

public final class GUID
implements Cloneable,
Comparable,
Serializable {
    static final long serialVersionUID = -7977671257884186039L;
    static String PROP_PORT = "org.apache.ode.uid.port";
    static int port = Integer.getInteger(PROP_PORT, 33666);
    private static final byte[] ipadd = new byte[]{127, 0, 0, 1};
    private static byte[] baseId = GUID.getSystemUniqId();
    private static short cnt = Short.MIN_VALUE;
    private static GUID _VM_GUID = new GUID();
    private final byte[] id;
    private transient String guidstring = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUID() {
        Class<GUID> clazz = GUID.class;
        synchronized (GUID.class) {
            short s = cnt = (short)(cnt + 1);
            byte[] byArray = baseId;
            if (cnt == Short.MAX_VALUE) {
                cnt = Short.MIN_VALUE;
                baseId = GUID.getSystemUniqId();
            }
            // ** MonitorExit[var3_1] (shouldn't be in output)
            this.id = new byte[]{ipadd[0], ipadd[1], ipadd[2], ipadd[3], byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0], (byte)(s >>> 8 & 0xFF), (byte)(s & 0xFF)};
            return;
        }
    }

    public GUID(String string) throws MalformedGuidException {
        if (string == null) {
            throw new MalformedGuidException(string);
        }
        this.id = new byte[14];
        this.stringToBytes(string);
    }

    public byte[] getGuid() {
        return this.id;
    }

    public static GUID getVMGUID() {
        return _VM_GUID;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        GUID gUID = (GUID)object;
        for (int n = 0; n < this.id.length; n = (int)((short)(n + 1))) {
            if (gUID.id[n] < this.id[n]) {
                return -1;
            }
            if (gUID.id[n] <= this.id[n]) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        try {
            return this.compareTo(object) == 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        for (int n2 = 0; n2 < this.id.length; n2 = (int)((short)(n2 + 1))) {
            n ^= this.id[n2] << n2 % 4;
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        for (int i = 0; i < 100000; ++i) {
            GUID gUID = new GUID();
            if (hashSet.contains(gUID)) {
                System.out.println("CONFLICT>>>");
            }
            hashSet.add(gUID);
            GUID gUID2 = new GUID(gUID.toString());
            if (!gUID2.toString().equals(gUID.toString()) || !gUID2.equals(gUID)) {
                System.out.println("INEQUALITY>>>");
                System.out.println(gUID2.toString());
                System.out.println(gUID.toString());
                continue;
            }
            System.out.println(gUID.toString());
        }
    }

    public String toString() {
        if (this.guidstring == null) {
            this.guidstring = this.mapBytesToChars();
        }
        return this.guidstring;
    }

    private static byte[] getSystemUniqId() {
        ProcessMutex processMutex = new ProcessMutex(port);
        try {
            processMutex.lock();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("ERROR: Could not establish unique starttime using\n       TCP port " + port + " for synchronization. \n" + "       Perhaps this port is used by anotherprocess? \n" + "       Check the '" + PROP_PORT + "' JAVA system property. \n");
            throw new RuntimeException("GUID.getSystemUniqId() FAILED!!!");
        }
        long l = System.currentTimeMillis();
        processMutex.unlock();
        return new byte[]{(byte)(l & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 56 & 0xFFL)};
    }

    private String mapBytesToChars() {
        BigInteger bigInteger = new BigInteger(this.id);
        return bigInteger.toString(34);
    }

    private void stringToBytes(String string) {
        BigInteger bigInteger = new BigInteger(string, 34);
        byte[] byArray = bigInteger.toByteArray();
        for (int i = 0; i < this.id.length; ++i) {
            this.id[i] = byArray[i];
        }
    }

    public static String makeGUID(String string) {
        String string2 = "0";
        int n = 32;
        int n2 = 34;
        int n3 = 31;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((string2 = new BigInteger(string2, n2).add(BigInteger.valueOf(c)).multiply(BigInteger.valueOf(n3)).toString(n2)).length() <= n) continue;
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static class MalformedGuidException
    extends Exception {
        private static final long serialVersionUID = -8922336058603571809L;

        public MalformedGuidException(String string) {
            super("Malformed guid: " + string);
        }
    }
}

