/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.MultiKeyMap;

public class InternPool {
    private static MultiKeyMap cachedValues = MultiKeyMap.decorate((AbstractHashedMap)new LRUMap());
    private static Set<String> cachedBlocks = Collections.synchronizedSet(new HashSet());

    protected InternPool() {
    }

    public static void runBlock(InternableBlock internableBlock) {
        String string = InternPool.getProcessId();
        cachedBlocks.add(string);
        internableBlock.run();
        cachedBlocks.remove(string);
        InternPool.clearAll(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object intern(Object object, Object object2) {
        String string = InternPool.getProcessId();
        if (!cachedBlocks.contains(string)) {
            return object2;
        }
        MultiKeyMap multiKeyMap = cachedValues;
        synchronized (multiKeyMap) {
            Object object3;
            ArrayList<Object> arrayList = (ArrayList<Object>)cachedValues.get((Object)string, object);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                cachedValues.put((Object)string, object, arrayList);
            }
            if (arrayList.contains(object2)) {
                object3 = arrayList.get(arrayList.indexOf(object2));
            } else {
                object3 = object2;
                arrayList.add(object3);
            }
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearAll(String string) {
        MultiKeyMap multiKeyMap = cachedValues;
        synchronized (multiKeyMap) {
            cachedValues.remove((Object)string);
        }
    }

    private static String getProcessId() {
        return String.valueOf(Thread.currentThread().getId());
    }

    public static interface InternableBlock {
        public void run();
    }
}

